<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<#noparse>
import React, { PureComponent } from 'react';
import { Subject } from "rxjs";
import axios from "axios";
import tinymce from "tinymce/tinymce";
import "tinymce/themes/modern";
import "tinymce/plugins/link";
import "tinymce/plugins/paste";
import "tinymce/plugins/table";
import "tinymce/plugins/image";
import "tinymce/plugins/imagetools";
import "tinymce/plugins/codesample";
import "tinymce/plugins/code";
import "tinymce/plugins/fullscreen";
import "tinymce/plugins/preview";
import { Util } from '../../../ibizsys/utils/util';
import './app-rich-text-editor.less';

/**
 * 输入属性
 *
 * @export
 * @interface RichTextProps
 */
export interface RichTextProps {
    /**
     * 传入表单项值
     *
     * @type {any}
     * @memberof RichTextProps
     */
    value: any;

    /**
     * 是否禁用
     * 
     *  @type {boolean}
     * @memberof RichTextProps
     */
    disabled: boolean;

    /**
     * 富文本高度
     * 
     *  @type {Number}
     * @memberof RichTextProps
     */
    height?: Number;

    /**
     * 当前语言
     * 
     *  @type {string}
     * @memberof RichTextProps
     */
    langu?: string;

    /**
     * 上传路径
     * 
     *  @type {String}
     * @memberof RichTextProps
     */
    uploadurl?: string;

    /**
     * 下载路径
     * 
     *  @type {String}
     * @memberof RichTextProps
     */
    downloadurl?: string;

    /**
     * 值变化事件
     *
     * @memberof RichTextProps
     */
    onChange: (value: string) => void;
}

/**
 * AppRadioGroup
 *
 * @export
 * @class AppRadioGroup
 * @extends {PureComponent}
 */
export default class AppRichTextEditor extends PureComponent<RichTextProps> {

    /**
     * 绑定值
     */
    public currentValue: any = undefined;

    /**
     * 是否禁用
     */
    public curDisabled: boolean = false;

    /**
     * 富文本id
     */
    public id: string = Util.createUUID();

    /**
     * 富文本高度
     */
    public height: Number | undefined;

    /**
     * 编辑器
     */
    public editor: any;

    /**
     * 当前语言
     */
    public langu: string = "zh_CN";

    /**
    * 上传路径
    * 
    */
    public uploadUrl: string = "";

    /**
     * 下载路径
     * 
     */
    public downloadUrl: string = "";

    constructor(props) {
        super(props);
        this.currentValue = props.value ? props.value : undefined;
        this.curDisabled = props.disabled ? true : false;
        this.height = props.height;
        this.langu = props.langu ? props.langu : "zh_CN";
        this.uploadUrl = props.uploadurl ? props.uploadur : "";
        this.downloadUrl = props.downloadurl ? props.downloadurl : "";
    }

    /**
     * 渲染之后调用
     * 
     */
    public componentDidMount() {
        this.init("");
    }

    /**
     * 在组件接收到一个新的 prop (或更新后)时被调用
     *
     * @memberof AppRichTextEditor
     */
    public componentWillReceiveProps(nextProps: Readonly<RichTextProps>, nextContext: any) {
        this.currentValue = nextProps.value ? nextProps.value : undefined;
        this.curDisabled = nextProps.disabled ? true : false;
        this.height = nextProps.height;
        this.langu = nextProps.langu ? nextProps.langu : "zh_CN";
        this.uploadUrl = nextProps.uploadurl ? nextProps.uploadurl : "";
        this.downloadUrl = nextProps.downloadurl ? nextProps.downloadurl : "";
    }

    /**
     * 初始化富文本
     * 
     * @param val 
     * @memberof AppRichTextEditor
     */
    public init(val: any) {
        let richtexteditor = this;
        tinymce.init({
            selector: "#" + this.id,
            height: this.height,
            min_height: 400,
            branding: false,
            plugins: [
                "link",
                "paste",
                "table",
                "image",
                "codesample",
                "code",
                "fullscreen",
                "preview"
            ],
            codesample_languages: [
                { text: "HTML/XML", value: "markup" },
                { text: "JavaScript", value: "javascript" },
                { text: "CSS", value: "css" },
                { text: "PHP", value: "php" },
                { text: "Ruby", value: "ruby" },
                { text: "Python", value: "python" },
                { text: "Java", value: "java" },
                { text: "C", value: "c" },
                { text: "C#", value: "csharp" },
                { text: "C++", value: "cpp" }
            ],
            codesample_content_css: "assets/tinymce/prism.css",
            skin_url: "assets/tinymce/skins/lightgray",
            language_url:
                "assets/tinymce/langs/" +
                (this.langu ? this.langu : "zh_CN") +
                ".js",
            setup: editor => {
                this.editor = editor;
                editor.on("blur", () => {
                    const content = editor.getContent();
                    this.handleChange(content);
                });
            },
            images_upload_handler: (bolbinfo, success, failure) => {
                const formData = new FormData();
                formData.append("file", bolbinfo.blob(), bolbinfo.filename());
                if (Object.is(richtexteditor.uploadUrl, "")) {
                    failure("需要提供上传路径");
                } else {
                    const _url = richtexteditor.uploadUrl;
                    richtexteditor.uploadFile(_url, formData).subscribe(
                        (response: any) => {
                            if (response.ret === 0 && response.files.length > 0) {
                                if (Object.is(richtexteditor.downloadUrl, "")) {
                                    failure("需要提供下载路径");
                                } else {
                                    const id = response.files[0].id;
                                    const url = `${richtexteditor.downloadUrl}?fileid=${id}`;
                                    success(url);
                                }
                            }
                        },
                        error => {
                            console.log(error);
                        }
                    );
                }
            },
            init_instance_callback: (editor: any) => {
                this.editor = editor;
                let value = this.currentValue && this.currentValue.length > 0 ? this.currentValue : "";
                if (this.editor) {
                    this.editor.setContent(value);
                }
                if (this.curDisabled) {
                    this.editor.setMode("readonly");
                }
            }
        });
    }

    /**
     * 上传文件
     * 
     * @param url 
     * @param formData 
     * @memberof AppRichTextEditor
     */
    public uploadFile(url, formData) {
        let _this = this;
        const subject = new Subject();
        axios({
            method: "post",
            url: url,
            data: formData,
            headers: { "Content-Type": "image/png", Accept: "application/json" }
        })
            .then(response => {
                if (response.status === 200) {
                    subject.next(response.data);
                } else {
                    subject.error(response);
                }
            })
            .catch(response => {
                subject.error(response);
            });
        return subject;
    }



    /**
     * 绘制内容
     *
     * @returns
     * @memberof AppRichTextEditor
     */
    public render() {
        return (
            <div>
                <textarea id={this.id}></textarea>
            </div>
        );
    }

    /**
     * 值变化事件
     * 
     * @param $event
     * @memberof AppRichTextEditor 
     */
    public handleChange($event) {
        this.props.onChange($event);
    }

    /**
     * 变更监测
     *
     * @protected
     * @memberof AppRichTextEditor
     */
    protected tick(): void {
        this.setState({
            date: new Date()
        });
    }

}
</#noparse>