import { Component, OnInit, Input, Output, EventEmitter, ViewContainerRef, ViewChild, OnDestroy, AfterViewInit } from '@angular/core';
import { Subject, Subscription } from 'rxjs';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Util } from '@global/util/util';
import { NzModalService } from 'ng-zorro-antd/modal';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@global/model/form-detail';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';

@Component({
	selector: '${ctrl.getCodeName()?lower_case}-${ctrl.getName()}',
	templateUrl: './${srffilepath2(ctrl.codeName)}.html',
	styleUrls: ['./${srffilepath2(ctrl.codeName)}.less'],
})
export class ${srfclassname('${ctrl.name}')} implements OnInit {

    /**
     * 数据对象
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    @Input()
    set data(val: any) {
        if (val) {
            this.formData = JSON.parse(JSON.stringify(val));
        }
    }

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    public formData: any = {};

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public detailsModel: any = {
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        ${formdetail.name}: ${P.getPartCode(formdetail, 'DETAIL_MODEL').code}, 
        </#list>
        <#if !ctrl.isNoTabHeader()>
        ${ctrl.name}: new FormTabPanelModel({ caption: '${ctrl.name}', detailType: 'TABPANEL', name: '${ctrl.name}', visible: true, isShowCaption: true, form: this, tabPages: [<#list ctrl.getPSDEFormPages() as formmenber><#if formmenber_index gt 0>, </#if>{ name: '${formmenber.name}', index: ${formmenber_index}, visible: <#if formmenber.getPSDEFDGroupLogic('PANELVISIBLE')??>false<#else>true</#if> }</#list>] }),
        </#if>
    };

    /**
     * 生命周期
     *
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    ngOnInit(): void {

    }
    <#list ctrl.getAllPSDEFormDetails() as formdetail>
    <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'BUTTON'>

    /**
     * ${formdetail.getCaption()}事件触发
     *
     * @param {*} $event
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    public ${formdetail.name}_click($event: any) {

    }
    </#if>
    </#list>

    /**
     * 表单逻辑
     *
     * @param {string} name
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof EditForm
     */
    public formLogic(name: string, newVal: any, oldVal: any) {
        <#if P.getPartCode(item,'FORM_LOGIC').code?length gt 0>
        ${P.getPartCode(item,'FORM_LOGIC').code}
        </#if>
    }
}