import { Vue, Component, Prop, Provide, Emit, Watch } from 'vue-property-decorator';
import { CreateElement } from 'vue';
import { Subject, Subscription } from 'rxjs';
import { ControlInterface } from '@/interface/control';
import { UICounter } from '@/utils';
import './${srffilepath2(ctrl.codeName)}-${ctrl.getControlType()?lower_case}.less';
<#if ctrl.getPSControls?? && ctrl.getPSControls()??>

<#list ctrl.getPSControls() as subctrl>
<#if subctrl.getControlType() != 'TOOLBAR' && subctrl.getControlType() != 'CONTEXTMENU'>
<#if subctrl.getPSDataEntity?? && subctrl.getPSDataEntity()??>
import view_${subctrl.getName()} from '@widget/${srffilepath2(subctrl.getPSDataEntity().getCodeName())}/${srffilepath2(subctrl.getCodeName())}-${subctrl.getControlType()?lower_case}/${srffilepath2(subctrl.getCodeName())}-${subctrl.getControlType()?lower_case}';
<#else>
import view_${subctrl.getName()} from '@widget/app/${srffilepath2(subctrl.getCodeName())}-${subctrl.getControlType()?lower_case}/${srffilepath2(subctrl.getCodeName())}-${subctrl.getControlType()?lower_case}';
</#if>
</#if>
</#list>
</#if>
<#--  语言资源入口  -->
<#ibizinclude>
./LANGBASE.tsx.ftl
</#ibizinclude>

<#if ctrl.getPSLayoutPanels?? && ctrl.getPSLayoutPanels()??>
<#list ctrl.getPSLayoutPanels() as panel>
import layout_${panel.getName()} from '@widget/${srffilepath2(panel.getPSDataEntity().getCodeName())}/${srffilepath2(panel.getCodeName())}-${panel.getControlType()?lower_case}/${srffilepath2(panel.getCodeName())}-${panel.getControlType()?lower_case}';
</#list>
</#if>
<#if import_block??>${import_block}</#if>

@Component({
    components: {
        <#if ctrl.getPSControls?? && ctrl.getPSControls()??>
        <#list ctrl.getPSControls() as subctrl>
        <#if subctrl.getControlType() != 'TOOLBAR' &&  subctrl.getControlType() != 'CONTEXTMENU'>
        view_${subctrl.getName()}, 
        </#if>
        </#list>
        </#if>
        <#if ctrl.getPSLayoutPanels?? && ctrl.getPSLayoutPanels()??>
        <#list ctrl.getPSLayoutPanels() as panel>
        layout_${panel.getName()},
        </#list>
        </#if>
        <#if components??>${components}</#if> 
    }
})
export default class ${srfclassname('${ctrl.codeName}')} extends Vue implements ControlInterface {

    /**
     * 名称
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop() public name?: string;

    /**
     * 视图通讯对象
     *
     * @type {Subject<ViewState>}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop() public viewState!: Subject<ViewState>;

    /**
     * 视图状态事件
     *
     * @protected
     * @type {(Subscription | undefined)}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    protected viewStateEvent: Subscription | undefined;
    <#if ctrl.getPSControls?? && ctrl.getPSControls()??>
    <#list ctrl.getPSControls() as childCtrl>
    <#if childCtrl.getControlType()??>
    <#if childCtrl.getHookEventNames()??>
    <#list childCtrl.getHookEventNames() as eventName>

    /**
     * ${childCtrl.name} 部件 ${eventName?lower_case} 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public ${childCtrl.name}_${eventName?lower_case}($event: any, $event2?: any) {
    <#if childCtrl.getPSControlLogics(eventName)??>
    <#list childCtrl.getPSControlLogics(eventName) as ctrlLogic>
    <#if ctrlLogic.getLogicType?? && ctrlLogic.getLogicType() == "APPVIEWENGINE" && ctrlLogic.getPSAppViewEngine()??>
        this.${ctrlLogic.getPSAppViewEngine().getName()}.onCtrlEvent('${childCtrl.name}', '${eventName?lower_case}', $event);
    <#else>
        <#if ctrlLogic.getEventArg()?? && ctrlLogic.getEventArg()?length gt 0>
        if (Object.is($event.tag, '${ctrlLogic.getEventArg()}')) {
            this.${ctrlLogic.name}($event, '<#if ctrlLogic.getLogicTag()?length gt 0>${ctrlLogic.getLogicTag()}</#if>', $event2);
        }
        <#else>
        this.${ctrlLogic.name}($event, '<#if ctrlLogic.getLogicTag()?length gt 0>${ctrlLogic.getLogicTag()}</#if>', $event2);
        </#if>
    </#if>
    </#list>
    </#if>
    }
    </#list>
    </#if>
    </#if>
    </#list>
    </#if>
    
<#if ctrl.getPSAppViewLogics?? && ctrl.getPSAppViewLogics()??>
<#list ctrl.getPSAppViewLogics() as logic>
<#if logic.getLogicTrigger() == "CUSTOM" || logic.getLogicTrigger() == "CTRLEVENT">

${P.getLogicCode(logic, "LOGIC.tsx").code}
</#if>
</#list>
</#if>

<#if ctrl.getPSUIActions?? && ctrl.getPSUIActions()??>
<#list ctrl.getPSUIActions() as uiAction>

${P.getLogicCode(uiAction, "LOGIC.tsx").code}
</#list>
</#if>

    /**
     * 序列号
     *
     * @private
     * @type {number}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private serialNumber: number = this.$util.createSerialNumber();

    /**
     * 请求行为序列号数组
     *
     * @private
     * @type {any[]}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private serialsNumber: any[] = [];

    /**
     * 添加序列号
     *
     * @private
     * @param {*} action
     * @param {number} serialnumber
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private addSerialNumber(action: any, serialnumber: number): void {
        const index = this.serialsNumber.findIndex((serial: any) => Object.is(serial.action, action));
        if (index === -1) {
            this.serialsNumber.push({ action: action, serialnumber: serialnumber })
        } else {
            this.serialsNumber[index].serialnumber = serialnumber;
        }
    }

    /**
     * 删除序列号
     *
     * @private
     * @param {*} action
     * @returns {number}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private getSerialNumber(action: any): number {
        const index = this.serialsNumber.findIndex((serial: any) => Object.is(serial.action, action));
        return this.serialsNumber[index].serialnumber;
    }

    /**
     * 关闭视图
     *
     * @param {any[]} args
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public closeView(args: any[]): void {
        let _this: any = this;
        _this.$emit('closeview', args);
    }
