import { Component, OnInit, Input, Output, EventEmitter, ViewContainerRef, ViewChild, OnDestroy, AfterViewInit } from '@angular/core';
import { Subject, Subscription } from 'rxjs';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Util } from '@global/util/util';
import { NzModalService } from 'ng-zorro-antd/modal';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@global/model/form-detail';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';

@Component({
	selector: '${ctrl.getCodeName()?lower_case}-${ctrl.getName()}',
	templateUrl: './${srffilepath2(ctrl.codeName)}.html',
	styleUrls: ['./${srffilepath2(ctrl.codeName)}.less'],
})
export class ${srfclassname('${ctrl.name}')} implements OnInit {

	constructor(private $util: Util) {
		
	}

    /**
     * 数据对象
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    @Input()
    set formData(val: any) {
        if (val) {
            this.data = JSON.parse(JSON.stringify(val));
            this.formLogic('', null, null);
        }
    }

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    public data: any = {};

	/**
	 * 表单数据变化
	 *
	 * @type {Subject<any>}
	 * @memberof ${srfclassname('${ctrl.name}')}
	 */
	public formDataChange: Subject<any> = new Subject<any>();

	/**
	 * 表单数据变化抛出事件
	 *
	 * @type {EventEmitter<any>}
	 * @memberof ${srfclassname('${ctrl.name}')}
	 */
	@Output() dataChangeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 代码表模型
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public codelistModel: any = {
        <#if view.getAllRelatedPSCodeLists()??>
        <#list  view.getAllRelatedPSCodeLists() as codelist>
        '${codelist.codeName}': [
            <#if codelist.getAllPSCodeItems()??>
            <#list codelist.getAllPSCodeItems() as codeItem>
            { 'id': '${codeItem.getCodeName()}', 'text': '${codeItem.getText()}', 'value': '${codeItem.getValue()}' },
            </#list>
            </#if>
        ]<#if codelist_has_next>,</#if>
        </#list>
        </#if>
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public rules: any = {
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'FORMITEM'>
        ${formdetail.getName()}: [<#--
            { type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值必须为<#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>数值<#else>字符串</#if>类型' },-->
            { required: <#if formdetail.isAllowEmpty()>false<#else>true</#if>, type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值不能为空' },
            <#if ctrl.getPSDEFormItemVRs()??>
            <#list ctrl.getPSDEFormItemVRs() as fideValueRule>
            <#if fideValueRule.getPSDEFormItemName() == formdetail.getName()>
              <#if fideValueRule.getPSSysValueRule()??>
                <#assign  valueRule = fideValueRule.getPSSysValueRule()/>
                <#if valueRule.getRuleType?? && valueRule.getRuleType()?? && valueRule.getRuleType() == "REG">
            { <#if valueRule.getRegExCode?? && valueRule.getRegExCode()??>pattern: /^${valueRule.getRegExCode()}$/</#if><#if valueRule.getRuleInfo?? &&  valueRule.getRuleInfo()??>, message: '${valueRule.getRuleInfo()}'</#if>, trigger: 'change' }
                </#if>
              </#if>
            </#if>            
            </#list>
            </#if>
        ],
        </#if>
        </#list>
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public detailsModel: any = {
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        ${formdetail.name}: ${P.getPartCode(formdetail, 'DETAIL_MODEL').code}, 
        </#list>
        <#if !ctrl.isNoTabHeader()>
        ${ctrl.name}: new FormTabPanelModel({ caption: '${ctrl.name}', detailType: 'TABPANEL', name: '${ctrl.name}', visible: true, isShowCaption: true, form: this, tabPages: [<#list ctrl.getPSDEFormPages() as formmenber><#if formmenber_index gt 0>, </#if>{ name: '${formmenber.name}', index: ${formmenber_index}, visible: <#if formmenber.getPSDEFDGroupLogic('PANELVISIBLE')??>false<#else>true</#if> }</#list>] }),
        </#if>
    };

    /**
     * 生命周期
     *
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    ngOnInit(): void {
        this.formLogic('', null, null);
        this.formDataChange.pipe(
			debounceTime(300),
            distinctUntilChanged()
		).subscribe(data => {
			this.dataChangeEvent.emit(JSON.parse(data.data));
			const field = data.field;
			if (field) {
				this.formLogic(field.name, field.value, field.oldVal);
				this.validateFormItem(field.name);
			}
		});
    }
    <#list ctrl.getAllPSDEFormDetails() as formdetail>
    <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'BUTTON'>

    /**
     * ${formdetail.getCaption()}事件触发
     *
     * @param {*} $event
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    public ${formdetail.name}_click($event: any) {

    }
    </#if>
    </#list>

	/**
	 * 表单项值变化事件
	 *
	 * @param {{name: string, value: any}} {name, value}
	 * @memberof ${srfclassname('${ctrl.name}')}
	 */
	public onFormDataChange(name: string, value: any): void {
		if (Object.is(this.data[name], value)) {
            return;
        }
		let oldVal: any = this.data[name];
		this.data[name] = value;
		this.formDataChange.next({ data: JSON.stringify(this.data), field: { name: name, value: value, oldVal: oldVal } });
	}

	/**
	 * 校验表单项
	 *
	 * @param {string} name
	 * @memberof EditForm
	 */
	public validateFormItem(name: string) {
		if (!name) {
			return;
		}
		const rule: any[] = this.rules[name];
		let message = '';
        let status = '';
        const val: any = this.data[name];
        rule.every((rule: any) => {
            if (rule.required && (!val || Object.is(val, '')) ) {
                message = rule.message;
                status = 'error';
                return false;
            } else if (val && rule.pattern && !rule.pattern.test(val)) {
                message = rule.message;
                status = 'error';
                return false;
            }
            return true;
        });
		this.detailsModel[name].error = message;
		this.detailsModel[name].validateStatus = status;
	}

    /**
     * 获取代码表集合
     *
     * @param {string} name
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    public getCodeList(name: string) {
        if (!name || !this.codelistModel[name]) {
            return [];
        }
        return this.codelistModel[name];
    }

    /**
     * 表单逻辑
     *
     * @param {string} name
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    public formLogic(name: string, newVal: any, oldVal: any) {
        <#if P.getPartCode(item,'FORM_LOGIC').code?length gt 0>
        ${P.getPartCode(item,'FORM_LOGIC').code}
        </#if>
    }
}