<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';
import { AppComponent } from './app.component';

const routes: Routes = [
  {
    path: '',
    children: [
      <#if app.getAllPSAppViews()??>
      <#list app.getAllPSAppViews() as singleView>
      {
        path: '${singleView.getPSAppModule().getCodeName()?lower_case}_${singleView.getCodeName()?lower_case}',
        loadChildren: '@pages/${singleView.getPSAppModule().getCodeName()?lower_case}/${srffilepath2('${singleView.getCodeName()}')}/${srffilepath2('${singleView.getCodeName()}')}.module#${srfclassname('${singleView.getCodeName()}')}Module'
      },
      </#list>
      </#if>
    ]
  },
  {
    path: '**',
    redirectTo: '',
    pathMatch: 'full'
  }
];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules, useHash: true })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule {}
