<#assign import_block>
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';
</#assign>
<#ibizinclude>
../@MACRO/CONTROL/CONTROL_HEADER.tsx.ftl
</#ibizinclude>

    /**
     * 获取多项数据
     *
     * @returns {any[]}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public getDatas(): any[] {
        return [this.data];
    }

    /**
     * 获取单项树
     *
     * @returns {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public getData(): any {
        return this.data;
    }

    /**
     * 是否默认保存
     *
     * @type {boolean}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop({ default: false }) public autosave?: boolean;

    /**
     * 显示处理提示
     *
     * @type {boolean}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop({ default: true }) public showBusyIndicator?: boolean;

    /**
     * 部件行为--更新
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop() public updateAction?: string;

    /**
     * 部件行为--加载草稿
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop() public loaddraftformAction?: string;

    /**
     * 部件行为--删除
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop() public removeAction?: string;

    /**
     * 部件行为--加载草稿
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop() public loaddraftAction?: string;

    /**
     * 部件行为--加载
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop() public loadAction?: string;

    /**
     * 部件行为--创建
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop() public createAction?: string;

    /**
     * 视图标识
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Prop() public viewtag!: string;

    /**
     * Api地址
     *
     * @type {string}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public url: string = '<#ibizinclude>../@MACRO/CONTROL/URL.tsx.ftl</#ibizinclude>';

    /**
     * 表单状态
     *
     * @type {Subject<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public formState: Subject<any> = new Subject();

    /**
     * 忽略表单项值变化
     *
     * @type {boolean}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public ignorefieldvaluechange: boolean = false;

    /**
     * 数据变化
     *
     * @private
     * @type {Subject<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private dataChang: Subject<any> = new Subject();

    /**
     * 视图状态事件
     *
     * @private
     * @type {(Subscription | undefined)}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private dataChangEvent: Subscription | undefined;

    /**
     * 原始数据
     *
     * @private
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private oldData: any = {};

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public data: any = {
        <#list ctrl.getPSDEFormItems() as item>
        ${item.getName()}: null,
        </#list>
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public rules: any = {
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'FORMITEM'>
        ${formdetail.getName()}: [
            { type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值必须为<#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>数值<#else>字符串</#if>类型', trigger: 'change' },
            { required: <#if formdetail.isAllowEmpty()>false<#else>true</#if>, type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值不能为空', trigger: 'change' },
            { required: <#if formdetail.isAllowEmpty()>false<#else>true</#if>, type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值不能为空', trigger: 'blur' },
        ],
        </#if>
        </#list>
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public detailsModel: any = {
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        ${formdetail.name}: ${P.getPartCode(formdetail, 'DETAIL_MODEL').code}, 
        </#list>
        <#if !ctrl.isNoTabHeader()>
        ${ctrl.name}: new FormTabPanelModel({ caption: '${ctrl.name}', detailType: 'TABPANEL', name: '${ctrl.name}', visible: true, isShowCaption: true, form: this, tabPages: [<#list ctrl.getPSDEFormPages() as formmenber><#if formmenber_index gt 0>, </#if>{ name: '${formmenber.name}', index: ${formmenber_index}, visible: <#if formmenber.getPSDEFDGroupLogic('PANELVISIBLE')??>false<#else>true</#if> }</#list>] }),
        </#if>
    };

    <#list ctrl.getPSDEFormItems() as item>
    /**
     * 监控表单属性 ${item.getName()} 值
     *
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    @Watch('data.${item.getName()}')
    on${srfclassname('${item.getName()}')}Change(newVal: any, oldVal: any) {
        this.formDataChange({ name: '${item.getName()}', newVal: newVal, oldVal: oldVal });
    }

    </#list>

    /**
     * 重置表单项值
     *
     * @private
     * @param {{ name: string, newVal: any, oldVal: any }} { name, newVal, oldVal }
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private resetFormData({ name, newVal, oldVal }: { name: string, newVal: any, oldVal: any }): void {
        <#list ctrl.getPSDEFormItems() as item>
        <#if item.getResetItemName?? && item.getResetItemName()??>
        if (Object.is(name, '${item.getResetItemName()}')) {
            this.onFormItemValueChange({ name: '${item.getName()}', value: null });
            <#if item.getValueItemName()?? && item.getValueItemName() != ''>
            this.onFormItemValueChange({ name: '${item.getValueItemName()}', value: null });
            </#if>
        }
        </#if>
        </#list>
    }

    /**
     * 表单逻辑
     *
     * @private
     * @param {{ name: string, newVal: any, oldVal: any }} { name, newVal, oldVal }
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private formLogic({ name, newVal, oldVal }: { name: string, newVal: any, oldVal: any }): void {
        <#if P.getPartCode(item,'FORM_LOGIC').code?length gt 0>
        ${P.getPartCode(item,'FORM_LOGIC').code}
        </#if>
        <#if ctrl.getPSDEFormItems()??>
        <#list ctrl.getPSDEFormItems() as formitem>
        <#if formitem.getPSDEFormItemUpdate()??>
        <#assign itemUpdate=formitem.getPSDEFormItemUpdate()/>

        if(Object.is(name, '${formitem.name}')){
            const details: string[] = [<#list itemUpdate.getPSDEFIUpdateDetails() as detail><#if detail_index gt 0>, </#if>'${detail.getPSDEFormDetailName()?lower_case}'</#list>];
            this.updateFormItems('${itemUpdate.codeName}', this.data, details, ${itemUpdate.isShowBusyIndicator()?c});
        }
        </#if>
        </#list>
        </#if>
    }

    /**
     * 表单值变化
     *
     * @private
     * @param {{ name: string, newVal: any, oldVal: any }} { name, newVal, oldVal }
     * @returns {void}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private formDataChange({ name, newVal, oldVal }: { name: string, newVal: any, oldVal: any }): void {
        if (this.ignorefieldvaluechange) {
            return;
        }
        this.resetFormData({ name: name, newVal: newVal, oldVal: oldVal });
        this.formLogic({ name: name, newVal: newVal, oldVal: oldVal });
        this.dataChang.next(JSON.stringify(this.data));
    }

    /**
     * 表单加载完成
     *
     * @private
     * @param {*} [data={}]
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private onFormLoad(data: any = {}): void {
        this.setFormEnableCond(data);
        this.fillForm(data);
        <#if ctrl.getControlType() == 'FORM'>
        this.oldData = {};
        Object.assign(this.oldData, JSON.parse(JSON.stringify(this.data)));
        this.$store.commit('viewaction/setViewDataChange', { viewtag: this.viewtag, viewdatachange: false });
        </#if>
        this.formLogic({ name: '', newVal: null, oldVal: null });
    }

    /**
     * 值填充
     *
     * @param {*} [_datas={}]
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public fillForm(_datas: any = {}): void {
        this.ignorefieldvaluechange = true;
        Object.keys(_datas).forEach((name: string) => {
            if (this.data.hasOwnProperty(name)) {
                this.data[name] = _datas[name];
            }
        });
        this.$nextTick(function () {
            this.ignorefieldvaluechange = false;
        })
    }

    /**
     * 设置表单项是否启用
     *
     * @protected
     * @param {*} data
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    protected setFormEnableCond(data: any): void {
        Object.values(this.detailsModel).forEach((detail: any) => {
            if (!Object.is(detail.detailType, 'FORMITEM')) {
                return;
            }
            const formItem: FormItemModel = detail;
            formItem.setEnableCond(data.srfuf);
        });
    }

    /**
     * 重置草稿表单状态
     *
     * @private
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private resetDraftFormStates(): void {
        const form: any = this.$refs.form;
        if (form) {
            form.resetFields();
        }
    }

    /**
     * 重置校验结果
     *
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public resetValidates(): void {
        Object.values(this.detailsModel).forEach((detail: any) => {
            if (!Object.is(detail.detailType, 'FORMITEM')) {
                return;
            }
            const formItem: FormItemModel = detail;
            formItem.setError('');
        });
    }

    /**
     * 填充校验结果 （后台）
     *
     * @param {any[]} fieldErrors
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public fillValidates(fieldErrors: any[]): void {
        fieldErrors.forEach((error: any) => {
            const formItem: FormItemModel = this.detailsModel[error.field];
            if (!formItem) {
                return;
            }
            this.$nextTick(() => {
                formItem.setError(error.message);
            });
        });
    }

    /**
     * 表单校验状态
     *
     * @returns {boolean} 
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public formValidateStatus(): boolean {
        const form: any = this.$refs.${ctrl.name};
        let validatestate: boolean = true;
        form.validate((valid: boolean) => {
            validatestate = valid ? true : false;
        });
        return validatestate
    }

    /**
     * 获取全部值
     *
     * @returns {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public getValues(): any {
        return this.data;
    }

    /**
     * 表单项值变更
     *
     * @param {{ name: string, value: any }} $event
     * @returns {void}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public onFormItemValueChange($event: { name: string, value: any }): void {
        if (!$event) {
            return;
        }
        if (!$event.name || Object.is($event.name, '') || !this.data.hasOwnProperty($event.name)) {
            return;
        }
        this.data[$event.name] = $event.value;
    }

    /**
     * 设置数据项值
     *
     * @param {string} name
     * @param {*} value
     * @returns {void}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public setDataItemValue(name: string, value: any): void {
        if (!name || Object.is(name, '') || !this.data.hasOwnProperty(name)) {
            return;
        }
        if (Object.is(this.data[name], value)) {
            return;
        }
        this.data[name] = value;
    }

    <#list ctrl.getAllPSDEFormDetails() as formdetail>
    <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'BUTTON'>
    <#if formdetail.getActionType?? && formdetail.getActionType()??>
    <#if formdetail.getActionType() == 'UIACTION'>

	/**
	 * 表单 ${formdetail.getCaption()} 事件
	 *
	 * @memberof @memberof ${srfclassname('${ctrl.codeName}')}
	 */
    public ${formdetail.getName()}_click($event: any): void {
        <#if formdetail.getPSUIAction?? && formdetail.getPSUIAction()??>
        <#assign uiaction = formdetail.getPSUIAction()>
        this.${ctrl.name}_${formdetail.getName()}_click(null, null, $event);
        </#if>

    }
    </#if>
    <#if formdetail.getActionType() == 'FIUPDATE'>

	/**
	 * 表单 ${formdetail.getCaption()} 事件
	 *
	 * @memberof @memberof ${srfclassname('${ctrl.codeName}')}
	 */
    public ${formdetail.getName()}_click($event: any): void {
        <#assign itemUpdate=formdetail.getPSDEFormItemUpdate()/>
        <#if formdetail.getParamPickupPSAppView()??>
        <#assign pickupview = formdetail.getParamPickupPSAppView()>
        const view: any = {
            viewname: '${srffilepath2(pickupview.getCodeName())}',
            title: '${pickupview.getTitle()}',
            height: ${pickupview.getHeight()?c},
            width: ${pickupview.getWidth()?c},
            <#if formdetail.getParamViewParamJO()??>
            paramjo: ${formdetail.getParamViewParamJO()},
            </#if>
        }
        const data: any = {
            srfparentdata: {
                srfparentkey: this.data.srfkey,
            }
        };
        if(view.paramjo) {
            Object.keys(view.paramjo).every((name: string) => {
                if (!name) {
                    return true;
                }
                let value: string = view.paramjo[name];
                if (value && value.startsWith('%') && value.endsWith('%')) {
                    const key: string = value.substring(1, value.length - 1);
                    if (!this.data.hasOwnProperty(key)) {
                        this.$Notice.error({ title: '错误', desc: `操作失败,未能找到当前表单项${r'${key}'}，无法继续操作` });
                        return false;
                    }
                    value = this.data[key];
                }
                Object.assign(data.srfparentdata, { [name]: value });
                return true;
            });
        }
        this.$appmodal.openModal(view, data).subscribe((result: any) => {
            if (result && Object.is(result.ret, 'OK') && result.datas && Array.isArray(result.datas)) {
                const arg: any = { ...JSON.parse(JSON.stringify(this.data)) } ;
                Object.assign(arg, { srfactionparam: result.datas });
                const details: string[] = [<#list itemUpdate.getPSDEFIUpdateDetails() as detail><#if detail_index gt 0>, </#if>'${detail.getPSDEFormDetailName()?lower_case}'</#list>];
                this.updateFormItems('${itemUpdate.codeName}', arg, details, ${itemUpdate.isShowBusyIndicator()?c});
            }
        });
        <#else>
        const details: string[] = [<#list itemUpdate.getPSDEFIUpdateDetails() as detail><#if detail_index gt 0>, </#if>'${detail.getPSDEFormDetailName()?lower_case}'</#list>];
        this.updateFormItems('${itemUpdate.codeName}', this.data, details, ${itemUpdate.isShowBusyIndicator()?c});
        </#if>
    }
    </#if>
    </#if>
    </#if>
    </#list>


    /**
     * 分组界面行为事件
     *
     * @param {*} $event
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public groupUIActionClick($event: any): void {
        if (!$event) {
            return;
        }
        const item:any = $event.item;
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'GROUPPANEL'>
        <#if formdetail.getPSUIActionGroup()??>
        <#list formdetail.getPSUIActionGroup().getPSUIActionGroupDetails() as uadetails>
        if (Object.is(item.name, '${formdetail.getName()}_${uadetails.getName()}')) {
            this.${ctrl.name}_${formdetail.getName()}_${uadetails.getName()}_click(null, null, $event.event);
        }
        </#list>
        </#if>
        </#if>
        </#list>
    }

    /**
     * Vue声明周期(处理组件的输入属性)
     *
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public created(): void {
        if (this.viewState) {
            this.viewStateEvent = this.viewState.subscribe(({ tag, action, data }) => {
                if (!Object.is(tag, this.name)) {
                    return;
                }
                if (Object.is('autoload', action)) {
                    this.autoLoad(data);
                }
                if (Object.is('load', action)) {
                    this.load(data);
                }
                if (Object.is('loaddraft', action)) {
                    this.loadDraft(data);
                }
                if (Object.is('save', action)) {
                    this.save(data);
                }
            });
        }
        this.dataChang
            .pipe(
                debounceTime(300),
                distinctUntilChanged()
            ).subscribe((data: any) => {
                if (this.autosave) {
                    this.autoSave();
                }
                <#if ctrl.getControlType() == 'FORM'>
                const state = !Object.is(JSON.stringify(this.oldData), JSON.stringify(this.data)) ? true : false;
                this.$store.commit('viewaction/setViewDataChange', { viewtag: this.viewtag, viewdatachange: state });
                </#if>
                <#if ctrl.getControlType() == 'SEARCHFORM' && ctrl.isEnableAutoSearch()>
                this.$emit('load', this.data);
                </#if>
            });
    }

    /**
     * vue 生命周期
     *
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public destroyed() {
        if (this.viewStateEvent) {
            this.viewStateEvent.unsubscribe();
        }
        if (this.dataChangEvent) {
            this.dataChangEvent.unsubscribe();
        }
        <#if destroyed_block??>
        ${destroyed_block}
        </#if>
    }

    /**
     * 拷贝内容
     *
     * @param {*} [arg={}]
     * @memberof @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public copy(arg: any = {}): void {
        this.loadDraft(arg);
    }

    /**
     * 部件刷新
     *
     * @param {any[]} args
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public refresh(args: any[]): void {
        let arg: any = {};
        if (this.data.srfkey && !Object.is(this.data.srfkey, '')) {
            Object.assign(arg, { srfkey: this.data.srfkey });
            this.load(arg);
            return;
        }
        if (this.data.srfkeys && !Object.is(this.data.srfkeys, '')) {
            Object.assign(arg, { srfkey: this.data.srfkeys });
            this.load(arg);
            return;
        }
    }

    /**
     * 自动加载
     *
     * @param {*} [arg={}]
     * @returns {void}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public autoLoad(arg: any = {}): void {
        if (arg.srfkey && !Object.is(arg.srfkey, '')) {
            Object.assign(arg, { srfkey: arg.srfkey });
            this.load(arg);
            return;
        }
        if (arg.srfkeys && !Object.is(arg.srfkeys, '')) {
            Object.assign(arg, { srfkey: arg.srfkeys });
            this.load(arg);
            return;
        }
        this.loadDraft(arg);
    }

    /**
     * 加载
     *
     * @private
     * @param {*} [opt={}]
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    private load(opt: any = {}): void {
        const arg: any = { ...opt };

        this.serialNumber++;
        const serialnumber = this.serialNumber;
        this.addSerialNumber(this.loadAction, serialnumber);

        const get: Promise<any> = this.$http.get(this.url + this.loadAction, arg, this.showBusyIndicator, serialnumber);
        get.then((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber(this.loadAction);
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (response && response.status === 200) {
                const data = response.data;
                this.onFormLoad(data);
                this.$emit('load', data);
                this.$nextTick(() => {
                    this.formState.next({ type: 'load', data: data });
                });
            }
        }).catch((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber(this.loadAction);
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (response && response.status === 401) {
                return;
            }
            if (!response || !response.status || !response.data) {
                this.$Notice.error({ title: '错误', desc: '系统异常' });
                return;
            }

            const { data: _data } = response;
            this.$Notice.error({ title: _data.title, desc: _data.message });
        });
    }

    /**
     * 加载草稿
     *
     * @param {*} [opt={}]
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public loadDraft(opt: any = {}): void {
        const arg: any = { ...opt } ;

        this.serialNumber++;
        const serialnumber = this.serialNumber;
        this.addSerialNumber(this.loaddraftAction, serialnumber);

        let post: Promise<any> = this.$http.post(this.url + this.loaddraftAction, arg, this.showBusyIndicator, serialnumber);
        post.then((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber(this.loaddraftAction);
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (!response.status || response.status !== 200) {
                if (response.errorMessage) {
                    this.$Notice.error({ title: '错误', desc: response.errorMessage });
                }
                return;
            }

            const data = response.data;
            this.resetDraftFormStates();
            this.onFormLoad(data);
            this.$emit('load', data);
            this.$nextTick(() => {
                this.formState.next({ type: 'load', data: data });
            });
            setTimeout(() => {
                const form: any = this.$refs.form;
                if (form) {
                    form.fields.forEach((field: any) => {
                        field.validateMessage = "";
                        field.validateState = "";
                        field.validateStatus = false;
                    });
                }
            });
        }).catch((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber(this.loaddraftAction);
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (response && response.status === 401) {
                return;
            }
            if (!response || !response.status || !response.data) {
                this.$Notice.error({ title: '错误', desc: '系统异常' });
                return;
            }

            const { data: _data } = response;
            this.$Notice.error({ title: _data.title, desc: _data.message });
        });
    }

    /**
     * 自动保存
     *
     * @param {*} [opt={}]
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public autoSave(opt: any = {}): void {
        if (!this.formValidateStatus()) {
            return;
        }

        const arg: any = { ...opt };
        const data = this.getValues();
        Object.assign(arg, data);
        const action: any = Object.is(data.srfuf, '1') ? this.updateAction : this.createAction;

        this.serialNumber++;
        const serialnumber = this.serialNumber;
        this.addSerialNumber(action, serialnumber);

        const post: Promise<any> = this.$http.post(this.url + action, arg, false, serialnumber);
        post.then((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber(action);
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (!response.status || response.status !== 200) {
                if (response.errorMessage) {
                    this.$Notice.error({ title: '错误', desc: response.errorMessage });
                }
                return;
            }

            const data = response.data;
            this.onFormLoad(data);
            this.$emit('save', data);
            <#if ctrl.getControlType() == 'FORM'>
            this.$store.dispatch('viewaction/datasaved', { viewtag: this.viewtag });
            </#if>
            this.$nextTick(() => {
                this.formState.next({ type: 'save', data: data });
            });
        }).catch((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber(action);
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (response && response.status === 401) {
                return;
            }
            if (!response || !response.status || !response.data) {
                this.$Notice.error({ title: '错误', desc: '系统异常' });
                return;
            }

            const { data: _data } = response;
            if (Object.is(_data.status, 'BAD_REQUEST') && _data.parameters && _data.parameters.fieldErrors) {
                this.resetValidates();
                this.fillValidates(_data.parameters.fieldErrors)
            }
            this.$Notice.error({ title: _data.title, desc: _data.message });
        });
    }

    /**
     * 保存
     *
     * @param {*} [opt={}]
     * @param {boolean} [showResultInfo]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public async save(opt: any = {}, showResultInfo?: boolean): Promise<any> {
        showResultInfo = showResultInfo === undefined ? true : false;
        if (!this.formValidateStatus()) {
            this.$Notice.error({ title: '错误', desc: '值规则校验异常' });
            return;
        }

        const arg: any = { ...opt };
        const data = this.getValues();
        Object.assign(arg, data);
        const action: any = Object.is(data.srfuf, '1') ? this.updateAction : this.createAction;

        this.serialNumber++;
        const serialnumber = this.serialNumber;
        this.addSerialNumber(action, serialnumber);

        const post: Promise<any> = this.$http.post(this.url + action, arg, this.showBusyIndicator, serialnumber);
        return new Promise((resolve: any, reject: any) => {
            post.then((response: any) => {
                const { serialnumber: _serialnumber } = response;
                const lastserialnumber = this.getSerialNumber(action);
                if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                    return;
                }

                if (!response.status || response.status !== 200) {
                    if (response.errorMessage) {
                        this.$Notice.error({ title: '错误', desc: response.errorMessage });
                    }
                    return;
                }

                const data = response.data;
                this.onFormLoad(data);
                this.$emit('save', data);
                <#if ctrl.getControlType() == 'FORM'>
                this.$store.dispatch('viewaction/datasaved', { viewtag: this.viewtag });
                </#if>
                this.$nextTick(() => {
                    this.formState.next({ type: 'save', data: data });
                });
                <#if ctrl.getFormFuncMode()?lower_case != 'wizardform'>
                if (showResultInfo) {
                    this.$Notice.success({ title: '', desc: (data.srfmajortext ? data.srfmajortext : '') + '&nbsp;保存成功！' });
                }
                </#if>

                resolve(response);
            }).catch((response: any) => {
                const { serialnumber: _serialnumber } = response;
                const lastserialnumber = this.getSerialNumber(action);
                if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                    return;
                }

                if (response && response.status === 401) {
                    return;
                }
                if (!response || !response.status || !response.data) {
                    this.$Notice.error({ title: '错误', desc: '系统异常' });
                    reject(response);
                    return;
                }

                const { data: _data } = response;
                if (Object.is(_data.status, 'BAD_REQUEST') && _data.parameters && _data.parameters.fieldErrors) {
                    this.resetValidates();
                    this.fillValidates(_data.parameters.fieldErrors)
                }
                this.$Notice.error({ title: _data.title, desc: _data.message });
                reject(response);
            });
        })
    }
<#if ctrl.getControlType() == 'FORM'>

    /**
     * 工作流提交
     *
     * @param {*} [data={}]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public async wfstart(data: any = {}): Promise<any> {
        if (!data.srfkey || Object.is(data.srfkey, '')) {
            return;
        }

        const arg: any = { ...data };

        const action = 'wfstart';
        this.serialNumber++;
        const serialnumber = this.serialNumber;
        this.addSerialNumber(action, serialnumber);

        const post: Promise<any> = this.$http.post(this.url + action, arg, this.showBusyIndicator, serialnumber);

        return new Promise((resolve: any, reject: any) => {
            post.then((response: any) => {
                const { serialnumber: _serialnumber } = response;
                const lastserialnumber = this.getSerialNumber(action);
                if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                    return;
                }
                if (response && response.status === 401) {
                    return;
                }

                if (!response || response.status !== 200) {
                    this.$Notice.error({ title: '', desc: '工作流提交失败, ' + response.info });
                    return;
                }
                this.$Notice.info({ title: '', desc: '工作流启动成功' });
                resolve(response);
            }).catch((response: any) => {
                const { serialnumber: _serialnumber } = response;
                const lastserialnumber = this.getSerialNumber(action);
                if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                    return;
                }

                if (response && response.status === 401) {
                    return;
                }
                if (!response || !response.status || !response.data) {
                    this.$Notice.error({ title: '错误', desc: '系统异常' });
                    reject(response);
                    return;
                }

                const { data: _data } = response;
                if (Object.is(_data.status, 'BAD_REQUEST') && _data.parameters && _data.parameters.fieldErrors) {
                    this.resetValidates();
                    this.fillValidates(_data.parameters.fieldErrors)
                }
                this.$Notice.error({ title: _data.title, desc: _data.message });
                reject(response);
            });
        });
    }

</#if>

    /**
     * 表单项更新
     *
     * @param {string} mode 界面行为名称
     * @param {*} [data={}] 请求数据
     * @param {string[]} updateDetails 更新项
     * @param {boolean} [showloading] 是否显示加载状态
     * @returns {void}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public updateFormItems(mode: string, data: any = {}, updateDetails: string[], showloading?: boolean): void {
        if (!mode || (mode && Object.is(mode, ''))) {
            return;
        }
        const action = mode.toLowerCase();
        const arg: any = { ...data };

        this.serialNumber++;
        const serialnumber = this.serialNumber;
        this.addSerialNumber('updateformitem/' + action, serialnumber);

        const post: Promise<any> = this.$http.post(this.url + 'updateformitem/' + action, arg, showloading, serialnumber);
        post.then((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber('updateformitem/' + action);
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (!response || response.status !== 200) {
                this.$Notice.error({ title: '错误', desc: '表单项更新失败' });
                return;
            }
            const data = response.data;
            const _data: any = {};
            updateDetails.forEach((name: string) => {
                if (!data.hasOwnProperty(name)) {
                    return;
                }
                Object.assign(_data, { [name]: data[name] });
            });
            this.setFormEnableCond(_data);
            this.fillForm(_data);
            this.formLogic({ name: '', newVal: null, oldVal: null });
            this.dataChang.next(JSON.stringify(this.data));
            this.$nextTick(() => {
                this.formState.next({ type: 'updateformitem', ufimode: arg.srfufimode, data: _data });
            });
        }).catch((response: any) => {
            const { serialnumber: _serialnumber } = response;
            const lastserialnumber = this.getSerialNumber('updateformitem/' + action);
            if (_serialnumber && lastserialnumber && _serialnumber < lastserialnumber) {
                return;
            }

            if (response && response.status === 401) {
                return;
            }
            if (!response || !response.status || !response.data) {
                this.$Notice.error({ title: '错误', desc: '系统异常' });
                return;
            }

            const { data: _data } = response;
            if (Object.is(_data.status, 'BAD_REQUEST') && _data.parameters && _data.parameters.fieldErrors) {
                this.resetValidates();
                this.fillValidates(_data.parameters.fieldErrors)
            }
            this.$Notice.error({ title: _data.title, desc: _data.message });
        });
    }

    /**
     * 回车事件
     *
     * @param {*} $event
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public onEnter($event: any): void {
        <#if ctrl.getControlType() == 'SEARCHFORM' && !ctrl.isEnableAutoSearch()>
        this.$emit('load', this.data);
        </#if>
    }
<#--  搜索表单：Begin  -->
<#if ctrl.getControlType() == 'SEARCHFORM'>
    <#if ctrl.getSearchButtonStyle() == 'DEFAULT'>

    /**
     * 搜索
     *
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public onSearch() {
        this.$emit('load', this.data);
    }

    /**
     * 重置
     *
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public onReset() {
        this.loadDraft();
    }
    </#if>
    <#if ctrl.getSearchButtonStyle() == 'SEARCHONLY'>

    /**
     * 搜索
     *
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public onSearch() {
        this.$emit('load', this.data);
    }
    </#if>
</#if>
<#--  搜索表单：End  -->

    /**
     * 内容绘制
     *
     * @returns
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public render() {
        return (
            ${P.getPartCode(item,'FORM').code}
        );
    }
}