## 超级表单 Angular 版

### 简介

超级表单 Angular 版是基于 Angular 8x 和消费iBiz模型构建而成的表单Demo（下面简称表单）。目前，该表单书写了我们表单常用的功能，如表单的栅格布局，flex布局，表单项动态显示，动态启用，动态空输入，表单值规则，表单的数据绑定，表单项的错误提示等功能。将iBiz工具产生的成果物及必要的基础文件拷贝到开发人员的 Aangular 项目中就能运行，这样可以大大的减轻开发人员的工作量。当然，由于业务场景的限制，如果有场景不满足，欢迎pr。

### 技术栈

angualr + less + ng-zorro-antd + rxjs

### 项目运行

git clone  XXXX
cd XXXX
npm install -g @angular/cli
npm i
ng serve

### 项目结构

目录 | 说明
----------- | -------------
├── e2e | 公共目录
├── src | 核心
│... ├── app | 包含定义应用逻辑和数据的组件文件。
│... │... ├── app-routing.module.ts | 定义根路由相关的文件
│... │... ├── app.component.html | 定义与根组件关联的 HTML 模板。
│... │... ├── app.component.less | 为根组件定义了基本的 CSS 样式表。
│... │... ├── app.component.spec.ts | 为根组件定义了一个单元测试。
│... │... ├── app.component.ts | 为应用的根组件定义逻辑 。
│... │... └── app.module.ts | 定义了根模块。
│... ├── assets | 包含静态资源文件。
│... ├── components | 组件
│... ├── global | 工具类
│... │... ├── model | 模型
│... │... │  └── form-detail | 表单成员模型
│... │... │...  ├── form-button.ts | 按钮
│... │... │...  ├── form-detail.ts | 表单成员
│... │... │...  ├── form-druipart.ts | 关系项
│... │... │...  ├── form-group-panel.ts | 分组面板
│... │... │...  ├── form-iframe.ts | 嵌入内容
│... │... │...  ├── form-item.ts | 表单项
│... │... │...  ├── form-page.ts | 分页
│... │... │...  ├── form-part.ts | 部件
│... │... │...  ├── form-row-item.ts | 直接内容
│... │... │...  ├── form-tab-page.ts | 分页面板
│... │... │...  ├── form-tab-panel.ts | 分页部件
│... │... │...  ├── form-user-control.ts | 用户控件
│... │... │...  └── index.ts | 表单成员模型导出声明文件
│... │... └── util | 工具类
│... │...... └── util.ts | 工具类对象
│... ├── pages | 视图
│... │... └── ***<应用模块代码名称>*** |  应用模块代码名称
│... │...... └── ***<视图代码名称>*** | 视图代码名称
│... │......... ├── ***<视图代码名称>***.html | 视图HTML 模板
│... │......... ├── ***<视图代码名称>***.less | 视图样式
│... │......... ├── ***<视图代码名称>***.module.ts | 定义视图模块
│... │......... └── ***<视图代码名称>***.ts | 视图（逻辑与内容）
│... ├── widgets | 部件
│... │... ├── app | 应用部件
│... │... │  └── ***<部件代码名称>***-***<部件标识>*** | 部件代码名称-部件标识
│... │... │...  ├── ***<部件代码名称>***-***<部件标识>***.html | 部件HTML 模板
│... │... │...  ├── ***<部件代码名称>***-***<部件标识>***.less | 部件样式
│... │... │...  ├── ***<部件代码名称>***-***<部件标识>***.mode.ts | 部件模型
│... │... │...  ├── ***<部件代码名称>***-***<部件标识>***.module.ts | 定义部件模块
│... │... │...  └── ***<部件代码名称>***-***<部件标识>***.ts | 部件（逻辑与内容）
│... │... └── ***<实体代码名称>*** | 实体代码名称
│... │...... └── ***<部件代码名称>***-***<部件标识>*** | 部件代码名称-部件标识
│... │......... ├── ***<部件代码名称>***-***<部件标识>***.html | 部件HTML 模板
│... │......... ├── ***<部件代码名称>***-***<部件标识>***.less | 表单样式
│... │......... ├── ***<部件代码名称>***-***<部件标识>***.mode.ts | 部件模型
│... │......... ├── ***<部件代码名称>***-***<部件标识>***.module.ts | 定义部件模块
│... │......... └── ***<部件代码名称>***-***<部件标识>***.ts | 表单（逻辑与内容）
│... ├── favicon.ico | 用作该应用在标签栏中的图标。
│... ├── index.html | 应用入口。
│... ├── main.ts | 应用的主要切入点。
│... ├── polyfills.ts | 为浏览器支持提供了polyfill脚本。
│... ├── styles.less | 列出为项目提供样式的 CSS 文件。
│... └── test.ts | 单元测试的主入口点。
├── .editorconfig | 代码编辑器的配置
├── .gitignore | 忽略应用提交
├── angular.json | Angular配置文件
├── browserslist | 目标浏览器配置表
├── karma.conf.js | 是命令 npm run unit 的入口配置文件
├── package-lock.json | 应用依赖包版本锁定
├── package.json | 应用依赖包管理
├── proxy.config.json | 远程代理配置
├── tsconfig.app.json | 包括模板编译器的选项。
├── tsconfig.json | ts编译的一些配置参数
├── tsconfig.spec.json | 应用测试的 TypeScript 配置。
├── tslint.json | TypeScript 格式校验
└── README.md | 简介文档

### 项目集成

- 以下为 iBiz 工具产生的表单成果物文件：

![produce](./img/form.png)

- 以下为表单所必须的基础文件：

![produce](./img/base.png)

开发人员集成表单也是非常方便的，通过以下几个步骤来将表单集成到项目中：

1. 将 iBiz 工具产生的表单成果物文件和表单所必须的基础文件都拷贝到项目中。

2. 在项目中的 tsconfig.json 中添加如下引用路径的别名：

![produce](./img/tsconfig.png)

3. 在需要使用表单组件的视图模块中导入表单模块，如图：

![produce](./img/module.png)

4. 在视图中使用使用表单。

### 效果展示

表单flex布局

![produce](./img/flex.png)

表单栅格布局

![produce](./img/grid.png)