<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';

@Component({
    selector: 'app-checkbox',
    templateUrl: './app-checkbox.html',
    styleUrls: ['./app-checkbox.less']
})
export class AppCheckbox implements OnInit {

    /**
     * 名称
     *
     * @type {string}
     * @memberof AppCheckbox
     */
    @Input() name: string;

    /**
     * 禁用
     *
     * @type {boolean}
     * @memberof AppCheckbox
     */
    @Input() disabled: boolean;

    /**
     * 值项
     *
     * @memberof AppCheckbox
     */
    @Input()
    set value(val) {
        this.itemValue = (val === 1 ? true : false);
    }

    /**
     * 编辑器值项
     *
     * @type {number}
     * @memberof AppCheckbox
     */
    public itemValue: boolean = false;

    /**
     * 表单项之变化事件
     *
     * @memberof AppCheckbox
     */
    @Output() public onFormItemValueChange: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 生命周期
     *
     * @memberof AppCheckbox
     */
    ngOnInit(): void {
        
    }

    /**
     * 值变化
     *
     * @param {boolean} $event
     * @memberof AppCheckbox
     */
    public onValueChange($event: boolean) {
        let val: number = $event ? 1 : 0;
        this.onFormItemValueChange.emit(val);
    }

}
