import { Component, OnInit, Input, Output, EventEmitter, ViewContainerRef, ViewChild, OnDestroy, AfterViewInit } from '@angular/core';
import { Subject, Subscription } from 'rxjs';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Util } from '@global/util/util';
import { NzModalService } from 'ng-zorro-antd/modal';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@global/model/form-detail';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';

@Component({
	selector: '${ctrl.getCodeName()?lower_case}-${ctrl.getName()}',
	templateUrl: './${srffilepath2(ctrl.codeName)}.html',
	styleUrls: ['./${srffilepath2(ctrl.codeName)}.less'],
})
export class ${srfclassname('${ctrl.name}')} implements OnInit {

	constructor(private $util: Util) {
		
	}

    /**
     * 数据对象
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    @Input()
    set formData(val: any) {
        if (val) {
            this.data = JSON.parse(JSON.stringify(val));
            this.formLogic('', null, null);
        }
    }

    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    public data: any = {};

	/**
	 * 表单数据变化
	 *
	 * @type {Subject<any>}
	 * @memberof ${srfclassname('${ctrl.name}')}
	 */
	public formDataChange: Subject<any> = new Subject<any>();

	/**
	 * 表单数据变化抛出事件
	 *
	 * @type {EventEmitter<any>}
	 * @memberof ${srfclassname('${ctrl.name}')}
	 */
	@Output() dataChangeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public rules: any = {
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'FORMITEM'>
        ${formdetail.getName()}: [
            { type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值必须为<#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>数值<#else>字符串</#if>类型' },
            { required: <#if formdetail.isAllowEmpty()>false<#else>true</#if>, type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()} 值不能为空' },
        ],
        </#if>
        </#list>
    }

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof ${srfclassname('${ctrl.codeName}')}
     */
    public detailsModel: any = {
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        ${formdetail.name}: ${P.getPartCode(formdetail, 'DETAIL_MODEL').code}, 
        </#list>
        <#if !ctrl.isNoTabHeader()>
        ${ctrl.name}: new FormTabPanelModel({ caption: '${ctrl.name}', detailType: 'TABPANEL', name: '${ctrl.name}', visible: true, isShowCaption: true, form: this, tabPages: [<#list ctrl.getPSDEFormPages() as formmenber><#if formmenber_index gt 0>, </#if>{ name: '${formmenber.name}', index: ${formmenber_index}, visible: <#if formmenber.getPSDEFDGroupLogic('PANELVISIBLE')??>false<#else>true</#if> }</#list>] }),
        </#if>
    };

    /**
     * 生命周期
     *
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    ngOnInit(): void {
        this.formLogic('', null, null);
        this.formDataChange.pipe(
			debounceTime(300),
            distinctUntilChanged()
		).subscribe(data => {
			this.dataChangeEvent.emit(JSON.parse(data));
		});
    }
    <#list ctrl.getAllPSDEFormDetails() as formdetail>
    <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'BUTTON'>

    /**
     * ${formdetail.getCaption()}事件触发
     *
     * @param {*} $event
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    public ${formdetail.name}_click($event: any) {

    }
    </#if>
    </#list>

	/**
	 * 表单项值变化事件
	 *
	 * @param {{name: string, value: any}} {name, value}
	 * @memberof ${srfclassname('${ctrl.name}')}
	 */
	public onFormDataChange(name: string, value: any): void {
		if (Object.is(this.data[name], value)) {
            return;
        }
		let oldVal: any = this.data[name];
		this.data[name] = value;
		this.formDataChange.next(JSON.stringify(this.data));
		this.formLogic(name, value, oldVal);
	}

    /**
     * 表单逻辑
     *
     * @param {string} name
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof ${srfclassname('${ctrl.name}')}
     */
    public formLogic(name: string, newVal: any, oldVal: any) {
        <#if P.getPartCode(item,'FORM_LOGIC').code?length gt 0>
        ${P.getPartCode(item,'FORM_LOGIC').code}
        </#if>
    }
}