import { NgZorroAntdModule } from 'ng-zorro-antd';
import { RouterModule } from '@angular/router';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

<#if view.getAllPSControls()??>
<#list view.getAllPSControls() as curctrl>
<#if curctrl.getControlType() != "TOOLBAR">
<#if curctrl.getPSDataEntity?? && curctrl.getPSDataEntity()??>
import { ${srfclassname('${curctrl.name}')}Module } from '@widgets/${srffilepath2(curctrl.getPSDataEntity().getCodeName())}/${srffilepath2(curctrl.getCodeName())}-${curctrl.getControlType()?lower_case}/${srffilepath2(curctrl.getCodeName())}-${curctrl.getControlType()?lower_case}.module';
</#if>
</#if>
</#list>
</#if>
import { ${srfclassname('${view.name}')}Page } from './${srffilepath2(view.getCodeName())}.page';


@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: ${srfclassname('${view.name}')}Page,
        data: { name: '${view.getPSAppModule().getCodeName()?lower_case}_${view.getCodeName()?lower_case}' }
      }
    ])
  ],
  exports: [ RouterModule ]
})
export class ${srfclassname('${view.name}')}RouteModule {}

@NgModule({
  imports: [
    NgZorroAntdModule,
    CommonModule,
    FormsModule,
    ${srfclassname('${view.name}')}RouteModule,
    <#if view.getAllPSControls()??>
    <#list view.getAllPSControls() as curctrl>
    <#if curctrl.getControlType() != "TOOLBAR">
    ${srfclassname('${curctrl.name}')}Module,
    </#if>
    </#list>
    </#if>
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  declarations: [${srfclassname('${view.name}')}Page],
  entryComponents: [${srfclassname('${view.name}')}Page],
  exports: [${srfclassname('${view.name}')}Page]
})
export class ${srfclassname('${view.name}')}Module {}
