<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';

@Component({
    selector: 'app-image-upload',
    templateUrl: './app-image-upload.html',
    styleUrls: ['./app-image-upload.less']
})
export class AppImageUpload implements OnInit {

    /**
     * 是否禁用
     *
     * @type {boolean}
     * @memberof AppImageUpload
     */
    @Input() disabled: boolean;

    /**
     * 值项
     *
     * @memberof AppImageUpload
     */
    @Input()
    set value(val: any) {
        if (val) {
            this.fileList = JSON.parse(val);
        } else {
            this.fileList = [];
        }
    }

    /**
     * 表单项之变化事件
     *
     * @memberof AppImageUpload
     */
    @Output() public onFormItemValueChange: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 上传地址
     *
     * @type {string}
     * @memberof AppImageUpload
     */
    public url: string = 'https://jsonplaceholder.typicode.com/posts/';

    /**
     * 已上传文件
     *
     * @type {any[]}
     * @memberof AppImageUpload
     */
    public fileList: any[] = [];

    /**
     * 上传列表配置
     *
     * @type {*}
     * @memberof AppImageUpload
     */
    public showUploadList: any = {
        showPreviewIcon: true,
        showRemoveIcon: true,
        hidePreviewIconInNonImage: true
    };

    /**
     * 预览显示
     *
     * @type {boolean}
     * @memberof AppImageUpload
     */
    public previewVisible: boolean = false;

    /**
     * 预览图片地址
     *
     * @type {string}
     * @memberof AppImageUpload
     */
    public previewImage: string | undefined = '';

    /**
     * 是否支持多选
     *
     * @type {boolean}
     * @memberof AppImageUpload
     */
    public isMultiple: boolean = false;

    /**
     * 生命周期
     *
     * @memberof AppImageUpload
     */
    ngOnInit(): void {

    }

    /**
     * 值变化
     *
     * @param {*} $event
     * @memberof AppImageUpload
     */
    public onChange($event) {
        if (Object.is($event.type, 'success')) {
            let files: any[] = JSON.parse(JSON.stringify(this.fileList));
            files.push($event.file);
            this.onFormItemValueChange.emit(JSON.stringify(files));
        } else if (Object.is($event.type, 'removed')) {
            let files: any[] = JSON.parse(JSON.stringify(this.fileList));
            let file = $event.file;
            let index = files.findIndex((item) => Object.is(item.uid, file.uid));
            files.splice(index, 1);
            this.onFormItemValueChange.emit(JSON.stringify(files));
        }
    }

    /**
     * 预览
     *
     * @param {*} file
     * @memberof AppImageUpload
     */
    public handlePreview(file: any) {
        this.previewImage = file.url || file.thumbUrl;
        this.previewVisible = true;
    }

}
