<#if item.getPSViewLogic?? && item.getPSViewLogic()??>
<#assign viewlogic = item.getPSViewLogic()/>
    /**
     * 打开编辑数据视图
     *
     * @param {any[]} args
     * @param {*} [params]
     * @param {*} [$event]
     * @param {*} [xData]
     * @memberof ${srfclassname('${view.name}')}
     */
    public ${item.name}(args: any[], params?: any, $event?: any, xData?: any) {
    <#if viewlogic.getOpenDataPSAppView()??>
        <#assign dataview = viewlogic.getOpenDataPSAppView()/>
        const data: any = { srfkey: args[0].srfkey, srfsourcekey: args[0].srfsourcekey };
        <#if dataview.isRedirectView()>
        <#--  打开顶级分页视图  -->
        // 打开顶级分页视图
        const openIndexViewTab = (viewpath: string, data: any) => {
            // const _params = this.$util.prepareRouteParmas({
            //     route: this.$route,
            //     sourceNode: this.$route.name,
            //     targetNode: viewpath,
            //     data: data,
            // });
            // this.$router.push({ name: viewpath, params: _params });
            this.$router.navigate([viewpath, data], {relativeTo: this.$route.parent.parent});
        };
        <#--  打开模态  -->
        // 打开模态
        const openPopupModal = (view: any, data: any) => {
            let container: Subject<any> = this.$appmodal.openModal(view, data);
            container.subscribe((result: any) => {
                if (!result || !Object.is(result.ret, 'OK')) {
                    return;
                }
                if (!xData || !(xData.refresh instanceof Function)) {
                    return;
                }
                xData.refresh(result.datas);
            });
        }
        <#--  打开抽屉  -->
        // 打开抽屉
        const openDrawer = (view: any, data: any) => {
            let container: Subject<any> = this.$appdrawer.openDrawer(view, data);
            container.subscribe((result: any) => {
                if (!result || !Object.is(result.ret, 'OK')) {
                    return;
                }
                if (!xData || !(xData.refresh instanceof Function)) {
                    return;
                }
                xData.refresh(result.datas);
            });
        }
        <#--  打开气泡卡片  -->
        // 打开气泡卡片
        const openPopOver = (view: any, data: any) => {
            let container: Subject<any> = this.$apppopover.openPop($event, view, data);
            container.subscribe((result: any) => {
                if (!result || !Object.is(result.ret, 'OK')) {
                    return;
                }
                if (!xData || !(xData.refresh instanceof Function)) {
                    return;
                }
                xData.refresh(result.datas);
            });
        }
        <#--  打开独立程序弹出  -->
        // 打开独立程序弹出 
        const openPopupApp = (url: string) => {
            window.open(url, '_blank');
        }
        <#assign dataview_de = dataview.getPSDataEntity()/>
        const url: string = '${app.getPKGCodeName()?lower_case}/${dataview_de.getPSSystemModule().codeName?lower_case}/${dataview_de.codeName?lower_case}/${dataview.getPSDEViewCodeName()?lower_case}/getmodel';
        this.$http.get(url, data).then((response: any) => {
            if (!response || response.status !== 200) {
                this.$Notice.error({ title: '错误', desc: '请求异常' });
            }
            if (response.status === 401) {
                return;
            }
            const { data: result } = response;
            if (!result) {
                return;
            }

            const _this: any = this;
            if (_this.srfparentdata) {
                if (Object.is(result.openmode, 'INDEXVIEWTAB') || Object.is(result.openmode, '')) {
                    Object.assign(data, _this.srfparentdata);
                } else {
                    Object.assign(data, { srfparentdata: _this.srfparentdata });
                }
            }

            if (result.viewparams && Object.keys(result.viewparams)) {
                Object.assign(data, result.viewparams);
            }

            if (Object.is(result.openmode, 'POPUPAPP') && result.url && !Object.is(result.url, '')) {
                openPopupApp(result.url);
            } else if (Object.is(result.openmode, 'INDEXVIEWTAB') || Object.is(result.openmode, '')) {
                const viewpath = ${r'`${result.viewmodule}_${result.viewname}`.toLowerCase()'};
                openIndexViewTab(viewpath, data);
            } else if (Object.is(result.openmode, 'POPUPMODAL')) {
                const viewname = this.$util.srfFilePath2(result.viewname);
                const view: any = {
                    viewname: viewname,
                    title: result.title,
                    width: result.width,
                    height: result.height,
                }
                openPopupModal(view, data);
            } else if (result.openmode.startsWith('DRAWER')) {
                const viewname = this.$util.srfFilePath2(result.viewname);
                const view: any = {
                    viewname: viewname,
                    title: result.title,
                    width: result.width,
                    height: result.height,
                    placement: result.openmode,
                }
                openDrawer(view, data);
            } else if (Object.is(result.openmode, 'POPOVER')) {
                const viewname = this.$util.srfFilePath2(result.viewname);
                const view: any = {
                    viewname: viewname,
                    title: result.title,
                    width: result.width,
                    height: result.height,
                    placement: result.openmode,
                }
                openPopOver(view, data);
            }  
        }).catch((response: any) => {
            if (!response || !response.status || !response.data) {
                this.$Notice.error({ title: '错误', desc: '系统异常！' });
                return;
            }
            if (response.status === 401) {
                return;
            }
            const { data: _data } = response;
            this.$Notice.error({ title: _data.title, desc: _data.message });
        })
        <#elseif dataview.getOpenMode() == 'INDEXVIEWTAB' || dataview.getOpenMode() == ''>
        <#--  打开顶级分页视图  -->
        const _this: any = this;
        if (_this.srfparentdata) {
            Object.assign(data, _this.srfparentdata);
        }
        const openIndexViewTab = (viewpath: string, data: any) => {
            // const _params = this.$util.prepareRouteParmas({
            //     route: this.$route,
            //     sourceNode: this.$route.name,
            //     targetNode: viewpath,
            //     data: data,
            // });
            // this.$router.push({ name: viewpath, params: _params });
            this.$router.navigate([viewpath, data], {relativeTo: this.$route.parent.parent});
        }
        openIndexViewTab('${dataview.getPSAppModule().codeName?lower_case}_${dataview.codeName?lower_case}', data);
        <#elseif dataview.getOpenMode() = 'POPUPMODAL'>
        <#--  打开模态  -->
        const _this: any = this;
        if (_this.srfparentdata) {
            Object.assign(data, { srfparentdata: _this.srfparentdata });
        }
        const openPopupModal = (view: any, data: any) => {
            let container: Subject<any> = this.$appmodal.openModal(view, data);
            container.subscribe((result: any) => {
                if (!result || !Object.is(result.ret, 'OK')) {
                    return;
                }
                if (!xData || !(xData.refresh instanceof Function)) {
                    return;
                }
                xData.refresh(result.datas);
            });
        }
        const view: any = {
            viewname: '${srffilepath2(dataview.getCodeName())}', 
            height: ${dataview.getHeight()?c}, 
            width: ${dataview.getWidth()?c},  
            title: '${dataview.title}', 
        };
        openPopupModal(view, data);
        <#elseif dataview.getOpenMode()?index_of('DRAWER') == 0>
        <#--  打开抽屉  -->
        const _this: any = this;
        if (_this.srfparentdata) {
            Object.assign(data, { srfparentdata: _this.srfparentdata });
        }
        const openDrawer = (view: any, data: any) => {
            let container: Subject<any> = this.$appdrawer.openDrawer(view, data);
            container.subscribe((result: any) => {
                if (!result || !Object.is(result.ret, 'OK')) {
                    return;
                }
                if (!xData || !(xData.refresh instanceof Function)) {
                    return;
                }
                xData.refresh(result.datas);
            });
        }
        const view: any = {
            viewname: '${srffilepath2(dataview.getCodeName())}', 
            height: ${dataview.getHeight()?c}, 
            width: ${dataview.getWidth()?c},  
            title: '${dataview.title}', 
            placement: '${dataview.getOpenMode()}',
        };
        openDrawer(view, data);
        <#elseif dataview.getOpenMode() == 'POPOVER'>
        <#--  打开气泡卡片  -->
        const _this: any = this;
        if (_this.srfparentdata) {
            Object.assign(data, { srfparentdata: _this.srfparentdata });
        }
        const openPopOver = (view: any, data: any) => {
            let container: Subject<any> = this.$apppopover.openPop($event, view, data);
            container.subscribe((result: any) => {
                if (!result || !Object.is(result.ret, 'OK')) {
                    return;
                }
                if (!xData || !(xData.refresh instanceof Function)) {
                    return;
                }
                xData.refresh(result.datas);
            });
        }
        const view: any = {
            viewname: '${srffilepath2(dataview.getCodeName())}', 
            height: ${dataview.getHeight()?c}, 
            width: ${dataview.getWidth()?c},  
            title: '${dataview.title}', 
            placement: '${dataview.getOpenMode()}',
        };
        openPopOver(view, data);
        <#else>
        this.$Notice.warning({ title: '错误', desc: '${dataview.title} 不支持该模式打开' });
        </#if>
    <#else>
    this.$Notice.warning({ title: '错误', desc: '未指定关系视图' });
    </#if>
    }
</#if>