import { Component, OnInit, AfterViewInit, Output, Input, EventEmitter, ViewChild } from '@angular/core';
import { Subject, Unsubscribable } from 'rxjs';
import { ActivatedRoute, Router } from '@angular/router';
import { NzNotificationService } from 'ng-zorro-antd/notification';
import { Http } from '@global/http/http';
import { Util } from '@global/util/util';
import { AppEnvironment } from 'src/environments/AppEnvironment';

<#if view.getPSAppViewEngines()??>
<#list view.getPSAppViewEngines() as engine>
import ${engine.getEngineType()}Engine from '@engine/${engine.getEngineCat()?lower_case}/${srffilepath2(engine.getEngineType())}-engine';
</#list>
</#if>

<#if view.getPSControls()??>
<#list view.getPSControls() as ctrl>
<#if ctrl.getControlType() != "TOOLBAR">
<#if ctrl.getPSDataEntity?? && ctrl.getPSDataEntity()??>
import { ${srfclassname('${ctrl.name}')} } from '@widgets/${srffilepath2(ctrl.getPSDataEntity().getCodeName())}/${srffilepath2(ctrl.getCodeName())}-${ctrl.getControlType()?lower_case}/${srffilepath2(ctrl.getCodeName())}-${ctrl.getControlType()?lower_case}';
<#else>
import { ${srfclassname('${ctrl.name}')} } from '@widgets/app/${srffilepath2(ctrl.getCodeName())}-${ctrl.getControlType()?lower_case}/${srffilepath2(ctrl.getCodeName())}-${ctrl.getControlType()?lower_case}';
</#if>
</#if>
</#list>
</#if>

<#if import_block??>
${import_block}
</#if>

@Component({
  selector: 'view-${srffilepath2('${view.getCodeName()}')?lower_case}',
  templateUrl: './${srffilepath2('${view.getCodeName()}')?lower_case}.page.html',
  styleUrls: ['./${srffilepath2('${view.getCodeName()}')?lower_case}.page.less']
})
export class ${srfclassname('${view.name}')}Page implements OnInit, AfterViewInit {

    /**
     * 构造方法
     * @param {NzNotificationService} $notice
     * @memberof IndexPage
     */
    constructor(private $util: Util, private $router: Router, private $route: ActivatedRoute, private $notice: NzNotificationService<#if constructor_block??>, ${constructor_block}</#if>) {}


<#if view.getPSControls()??>
<#list view.getPSControls() as ctrl>
<#if ctrl.getControlType() != "TOOLBAR">
    /**
     * 子组件${srfclassname('${ctrl.name}')}
     *
     * @public
     * @type {Subject}
     * @memberof ${srfclassname('${view.name}')}
     */
    @ViewChild(${srfclassname('${ctrl.name}')}, {static: false})
    private ${ctrl.name?lower_case}: ${srfclassname('${ctrl.name}')};
</#if>
</#list>
</#if>

	/**
	 * 视图标识
	 *
	 * @type {string}
	 * @memberof AppDashboardView
	 */
	public viewtag: string = '${view.getId()}';

    /**
     * 父数据对象
     *
     * @protected
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}
     */
    protected srfparentdata: any = {};

    /**
     * 视图订阅对象
     *
     * @public
     * @type {Subject}
     * @memberof ${srfclassname('${view.name}')}
     */
    public viewState: Subject<ViewState> = new Subject();

    /**
     * 视图值变化事件
     *
     * @public
     * @type {EventEmitter}
     * @memberof ${srfclassname('${view.name}')}
     */    
    @Output() public viewdataschange = new EventEmitter();

    /**
     * 视图参数
     *
     * @public
     * @type {Subject}
     * @memberof ${srfclassname('${view.name}')}
     */
    @Input() public viewdata: any;

<#if view.hasPSControl('toolbar')>
${P.getCtrlCode('toolbar', 'CONTROL.ts').code}
</#if>

    /**
     * 视图加载完成事件
     *
     * @type {EventEmitter<any>}
     * @memberof ${srfclassname('${view.name}')}
     */
    @Output() public viewloadEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 视图数据变化事件
     *
     * @type {EventEmitter<any>}
     * @memberof ${srfclassname('${view.name}')}
     */
    @Output() public viewdataschangeEvent: EventEmitter<any> = new EventEmitter<any>();

    /**
     * 视图模型数据
     *
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}
     */
    public model: any = {
        srfTitle: '<#if view.getTitle()??>${view.getTitle()}</#if>',
        srfCaption: '${view.getCaption()}',
        srfSubCaption: '<#if view.getSubCaption()??>${view.getSubCaption()}</#if>',
        dataInfo: ''
    };

    <#if view.getPSAppViewEngines()??>
    <#list view.getPSAppViewEngines() as engine>
    /**
     * 视图引擎
     *
     * @private
     * @type {Engine}
     * @memberof ${srfclassname('${view.name}')}
     */
    private ${engine.getName()?lower_case}: ${engine.getEngineType()}Engine = new ${engine.getEngineType()}Engine();
    </#list>
    </#if>

    /**
     * 引擎初始化
     *
     * @private
     * @memberof ${srfclassname('${view.name}')}
     */
    private engineInit(): void {
    <#if view.getPSAppViewEngines()??>
    <#list view.getPSAppViewEngines() as engine>
        this.${engine.getName()?lower_case}.init({
            view: this,
        <#if engine.getPSAppViewEngineParams()??>
            <#list engine.getPSAppViewEngineParams() as param>
            <#if param.getParamType() == "LOGIC" && param.getPSAppViewLogic()??>
            ${param.getName()?lower_case}: (args: any[], params?: any, $event?: any, xData?: any) => {
                this.${param.getPSAppViewLogic().getName()}(args, params, $event, xData);
            },
            </#if>
            <#if param.getParamType() == "CTRL" && param.getPSControl()??>
            ${param.getName()?lower_case}: this.${param.getPSControl().getName()},
            </#if>
            <#if param.getParamType() == "VALUE" && param.getValue()??>
            ${param.getName()?lower_case}: '${param.getValue()?c}',
            </#if>
            </#list>
        </#if>
            isLoadDefault: <#if view.isLoadDefault?? && !view.isLoadDefault()>false<#else>true</#if>,
        });
    </#list>
    </#if>
    }

    /**
     * angular生命周期
     *
     * @memberof ${srfclassname('${view.name}')}
     */
    public ngOnInit() {

    }

     /**
     * angular生命周期(在ngOnInit之后)
     *
     * @memberof ${srfclassname('${view.name}')}
     */
    public ngAfterViewInit() {
        <#if view.getPSAppViewEngines()??>
        this.engineInit();
        </#if>
        <#if mounted_block??>${mounted_block}</#if>
    }

    <#if view.getPSControls()??>
    <#list view.getPSControls() as ctrl>
    <#if ctrl.getControlType()??>
    <#if ctrl.getHookEventNames()??>
    <#list ctrl.getHookEventNames() as eventName>

    /**
     * ${ctrl.name} 部件 ${eventName?lower_case} 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof ${srfclassname('${view.name}')}
     */
    public ${ctrl.name}_${eventName?lower_case}($event: any, $event2?: any) {
    <#if ctrl.getPSControlLogics(eventName)??>
    <#list ctrl.getPSControlLogics(eventName) as ctrlLogic>
    <#if ctrlLogic.getLogicType() == "APPVIEWENGINE" && ctrlLogic.getPSAppViewEngine()??>
        this.${ctrlLogic.getPSAppViewEngine().getName()}.onCtrlEvent('${ctrl.name}', '${eventName?lower_case}', $event);
    <#else>
        <#if ctrlLogic.getEventArg()?? && ctrlLogic.getEventArg()?length gt 0>
        if (Object.is($event.tag, '${ctrlLogic.getEventArg()}')) {
            this.${ctrlLogic.name}($event, '', $event2);
        }
        <#else>
        this.${ctrlLogic.name}($event, '', $event2);
        </#if>
    </#if>
    </#list>
    </#if>
    }

    </#list>
    </#if>
    </#if>
    </#list>
    </#if>

<#if view.getPSAppViewLogics()??>
<#list view.getPSAppViewLogics() as logic>
<#if logic.getLogicTrigger() == "CUSTOM" || logic.getLogicTrigger() == "CTRLEVENT">

${P.getLogicCode(logic, "LOGIC.tsx").code}
</#if>
</#list>
</#if>

<#if view.getPSUIActions()??>
<#list view.getPSUIActions() as uiAction>

${P.getLogicCode(uiAction, "LOGIC.tsx").code}
</#list>
</#if>