<#--  前台界面行为  -->
<#if front_block??>
${front_block}
<#else>
    /**
     * ${item.getCaption()}
     *
     * @param {any[]} arg
     * @param {*} [params]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${view.name}')}
     */
    public ${item.getFullCodeName()}(args: any[], params?: any, $event?: any, xData?: any): Promise<any> {
<#if item.getActionTarget() == 'SINGLEDATA'>
        return new Promise((resolve: any, reject: any) => {
            this.$Notice.error({ title: '错误', desc: '不支持单项数据' });
        });
<#elseif item.getActionTarget() == 'MULTIDATA'>
        return new Promise((resolve: any, reject: any) => {
            this.$Notice.error({ title: '错误', desc: '不支持多项数据' });
        });
<#else>
        const data: any = { srfparentdata: {} };
        const _this: any = this;
        if (_this.srfparentdata) {
            Object.assign(data.srfparentdata, _this.srfparentdata);
        }
    <#if item.getActionTarget() == 'SINGLEKEY'>

        <#--  单项数据主键  -->
        if (args.length > 0) {
            Object.assign(data, { srfkey: args[0].srfkey });
        }

        // 值项名称 - 单项数据主键，默认为srfkey
        const valueItem: string = '<#if item.getValueItem?? && item.getValueItem() != ''>${item.getValueItem()}<#else>srfkey</#if>';
        // 数据项名称 - 单项数据主键，默认为srfkey
        const paramItem: string = '<#if item.getParamItem?? && item.getParamItem() != ''>${item.getParamItem()}<#else>srfkey</#if>';
        if (args.length > 0 && args[0].hasOwnProperty(valueItem)) {
            const _params2: any = {};
            Object.assign(_params2, { [paramItem]: args[0][valueItem] });
            // 参数层级处理
            if (Object.is(paramItem, 'srfkey')) {
                Object.assign(data, _params2);
            } else {
                Object.assign(data.srfparentdata, _params2);
            }
            // 非默认值转换 删除原始值
            if (Object.is(valueItem, 'srfkey') && !Object.is(paramItem, 'srfkey')) {
                delete data.srfkey;
            }
        }
    </#if>
    <#if item.getActionTarget() == 'MULTIKEY'>
    
        <#--  多项数据主键  -->
        let keys: string[] = [];
        args.forEach((arg: any) => {
            if (arg.srfkey) {
                keys.push(arg.srfkey);
            }
        });
        if (keys.length > 0) {
            Object.assign(data, { srfkeys: keys.join(';') });
        }

        // 值项名称 -  多项数据主键，默认为srfkey
        const valueItem: string = '<#if item.getValueItem?? && item.getValueItem() != ''>${item.getValueItem()}<#else>srfkey</#if>';
        // 数据项名称 - 多项数据主键，默认为srfkeys
        const paramItem: string = '<#if item.getParamItem?? && item.getParamItem() != ''>${item.getParamItem()}<#else>srfkeys</#if>';
        const _params2: any = {};
        let _keys: string[] = [];
        args.forEach((arg: any) => {
            if (arg.hasOwnProperty(valueItem)) {
                _keys.push(arg[valueItem]);
            }
        });

        Object.assign(_params2, { [paramItem]: _keys.join(';') });
        // 参数层级处理
        if (Object.is(paramItem, 'srfkeys')) {
            Object.assign(data, _params2);
        } else {
            Object.assign(data.srfparentdata, _params2);
        }
    </#if>

        if (params && Object.keys(params).length > 0) {
            const _params: any = {};
            const arg: any = args[0];
            Object.keys(params).forEach((name: string) => {
                if (!name) {
                    return;
                }
                let value: string | null = params[name];
                if (value && value.startsWith('%') && value.endsWith('%')) {
                    const key = value.substring(1, value.length - 1);
                    if (arg && arg.hasOwnProperty(key)) {
                        value = (arg[key] !== null && arg[key] !== undefined) ? arg[key] : null;
                    } else {
                        value = null;
                    }
                }
                Object.assign(_params, { [name]: value });
            });
            Object.assign(data.srfparentdata, _params);
        }

    <#if item.getFrontProcessType() == 'OPENHTMLPAGE'>
        <#--  打开独立程序弹出  -->
        return new Promise((resolve, reject) => {
            const openPopupApp = (url: string) => {
                window.open(url, '_blank');
                resolve();
            }
            const localdata: any = this.$store.getters.getLocalData();
            const url = `${item.getHtmlPageUrl()}`;
            openPopupApp(url);
        });
    <#elseif (item.getFrontProcessType() == 'TOP' || item.getFrontProcessType() == 'WIZARD') && item.getFrontPSAppView(view)??>
        <#assign frontview = item.getFrontPSAppView(view)>
        return new Promise((resolve, reject) => {
            <#if frontview.isRedirectView()>
            <#--  打开顶级分页视图  -->
            // 打开顶级分页视图
            // 所有数据保持在同一级
            if (data.srfparentdata) {
                Object.assign(data, data.srfparentdata);
                delete data.srfparentdata;
            }
            const openIndexViewTab = (viewpath: string, data: any) => {
                const _params = this.$util.prepareRouteParmas({
                    route: this.$route,
                    sourceNode: this.$route.name,
                    targetNode: viewpath,
                    data: data,
                });
                this.$router.push({ name: viewpath, params: _params });
                resolve();
            }
            <#--  打开模态  -->
            // 打开模态
            const openPopupModal = (view: any, data: any) => {
                let container: Subject<any> = this.$appmodal.openModal(view, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = this;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    } else if (_this.refresh && _this.refresh instanceof Function) {
                        _this.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas, params, $event, xData);
                    }
                    </#if>
                    resolve(result.datas);
                });
            }
            <#--  打开抽屉  -->
            // 打开抽屉
            const openDrawer = (view: any, data: any) => {
                let container: Subject<any> = this.$appdrawer.openDrawer(view, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = this;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    } else if (_this.refresh && _this.refresh instanceof Function) {
                        _this.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas, params, $event, xData);
                    }
                    </#if>
                    resolve(result.datas);
                });
            }
            <#--  打开气泡卡片  -->
            // 打开气泡卡片
            const openPopOver = (view: any, data: any) => {
                let container: Subject<any> = this.$apppopover.openPop($event, view, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = this;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    } else if (_this.refresh && _this.refresh instanceof Function) {
                        _this.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas, params, $event, xData);
                    }
                    </#if>
                    resolve(result.datas);
                });
            }
            <#--  打开独立程序弹出  -->
            // 打开独立程序弹出 
            const openPopupApp = (url: string) => {
                window.open(url, '_blank');
                resolve();
            }
            <#assign frontview_de = frontview.getPSDataEntity()/>
            const url: string = '/${app.getPKGCodeName()?lower_case}/${frontview_de.getPSSystemModule().codeName?lower_case}/${frontview_de.codeName?lower_case}/${frontview.getPSDEViewCodeName()?lower_case}/getmodel';
            this.$http.get(url, data).then((response: any) => {
                if (!response || response.status !== 200) {
                    this.$Notice.error({ title: '错误', desc: '请求异常' });
                }
                if (response.status === 401) {
                    return;
                }
                const { data: result } = response;
                if (!result) {
                    return reject(response);
                }

                if (result.viewparams && Object.keys(result.viewparams)) {
                    Object.assign(data, result.viewparams);
                }

                if (Object.is(result.openmode, 'POPUPAPP') && result.url && !Object.is(result.url, '')) {
                    openPopupApp(result.url);
                } else if (Object.is(result.openmode, 'INDEXVIEWTAB') || Object.is(result.openmode, '')) {
                    const viewpath = ${r'`${result.viewmodule}_${result.viewname}`.toLowerCase()'};
                    // 所有数据保持在同一级
                    if (data.srfparentdata) {
                        Object.assign(data, data.srfparentdata);
                        delete data.srfparentdata;
                    }
                    openIndexViewTab(viewpath, data);
                } else if (Object.is(result.openmode, 'POPUPMODAL')) {
                    const viewname = this.$util.srfFilePath2(result.viewname);
                    const view: any = {
                        viewname: viewname,
                        title: result.title,
                        width: result.width,
                        height: result.height,
                    }
                    openPopupModal(view, data);
                } else if (result.openmode.startsWith('DRAWER')) {
                    const viewname = this.$util.srfFilePath2(result.viewname);
                    const view: any = {
                        viewname: viewname,
                        title: result.title,
                        width: result.width,
                        height: result.height,
                        placement: result.openmode,
                    }
                    openDrawer(view, data);
                } else if (Object.is(result.openmode, 'POPOVER')) {
                    const viewname = this.$util.srfFilePath2(result.viewname);
                    const view: any = {
                        viewname: viewname,
                        title: result.title,
                        width: result.width,
                        height: result.height,
                        placement: result.openmode,
                    }
                    openPopOver(view, data);
                }  
            }).catch((response: any) => {
                if (!response || !response.status || !response.data) {
                    this.$Notice.error({ title: '错误', desc: '系统异常！' });
                    return;
                }
                if (response.status === 401) {
                    return;
                }
                const { data: _data } = response;
                this.$Notice.error({ title: _data.title, desc: _data.message });
            })
            <#elseif frontview.getOpenMode() =='INDEXVIEWTAB' || frontview.getOpenMode() == ''>
            <#--  打开顶级分页视图  -->
            // 所有数据保持在同一级
            if (data.srfparentdata) {
                Object.assign(data, data.srfparentdata);
                delete data.srfparentdata;
            }
            const openIndexViewTab = (viewpath: string, data: any) => {
                const _params = this.$util.prepareRouteParmas({
                    route: this.$route,
                    sourceNode: this.$route.name,
                    targetNode: viewpath,
                    data: data,
                });
                this.$router.push({ name: viewpath, params: _params });
                resolve();
            }
            openIndexViewTab('${frontview.getPSAppModule().codeName?lower_case}_${frontview.codeName?lower_case}', data);
            <#elseif frontview.getOpenMode() = 'POPUPMODAL'>
            <#--  打开模态  -->
            const openPopupModal = (view: any, data: any) => {
                let container: Subject<any> = this.$appmodal.openModal(view, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = this;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    } else if (_this.refresh && _this.refresh instanceof Function) {
                        _this.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas, params, $event, xData);
                    }
                    </#if>
                    resolve(result.datas);
                });
            }
            const view: any = {
                viewname: '${srffilepath2(frontview.getCodeName())}', 
                height: ${frontview.getHeight()?c}, 
                width: ${frontview.getWidth()?c},  
                title: '${frontview.title}', 
            };
            openPopupModal(view, data);
            <#elseif frontview.getOpenMode()?index_of('DRAWER') == 0>
            <#--  打开抽屉  -->
            const openDrawer = (view: any, data: any) => {
                let container: Subject<any> = this.$appdrawer.openDrawer(view, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = this;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    } else if (_this.refresh && _this.refresh instanceof Function) {
                        _this.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas, params, $event, xData);
                    }
                    </#if>
                    resolve(result.datas);
                });
            }
            const view: any = {
                viewname: '${srffilepath2(frontview.getCodeName())}', 
                height: ${frontview.getHeight()?c}, 
                width: ${frontview.getWidth()?c},  
                title: '${frontview.title}', 
                placement: '${frontview.getOpenMode()}',
            };
            openDrawer(view, data);
            <#elseif frontview.getOpenMode() == 'POPOVER'>
            <#--  打开气泡卡片  -->
            const openPopOver = (view: any, data: any) => {
                let container: Subject<any> = this.$apppopover.openPop($event, view, data);
                container.subscribe((result: any) => {
                    if (!result || !Object.is(result.ret, 'OK')) {
                        return;
                    }
                    const _this: any = this;
                    <#--  是否重新加载数据  -->
                    <#if item.isReloadData?? && item.isReloadData()>
                    if (xData && xData.refresh && xData.refresh instanceof Function) {
                        xData.refresh(args);
                    } else if (_this.refresh && _this.refresh instanceof Function) {
                        _this.refresh(args);
                    }
                    </#if>
                    <#--  后续界面行为  -->
                    <#if item.getNextPSUIAction?? && item.getNextPSUIAction()??>
                    <#assign nextPSUIAction = item.getNextPSUIAction()/>
                    if (_this.${nextPSUIAction.getFullCodeName()} && _this.${nextPSUIAction.getFullCodeName()} instanceof Function) {
                        _this.${nextPSUIAction.getFullCodeName()}(result.datas, params, $event, xData);
                    }
                    </#if>
                    resolve(result.datas);
                });
            }
            const view: any = {
                viewname: '${srffilepath2(frontview.getCodeName())}', 
                height: ${frontview.getHeight()?c}, 
                width: ${frontview.getWidth()?c},  
                title: '${frontview.title}', 
                placement: '${frontview.getOpenMode()}',
            };
            openPopOver(view, data);
            <#else>
            this.$Notice.warning({ title: '错误', desc: '${dataview.title} 不支持该模式打开' });
            </#if>
        });
    <#elseif item.getFrontProcessType() == 'OTHER'>
        // 自定义实体界面行为
        this.$Notice.warning({ title: '错误', desc: '${item.getCaption()} 未实现' });
        return new Promise((resolve: any, reject: any) => {
            
        });
    </#if>
</#if>
    }
</#if>
    