import { NgZorroAntdModule } from 'ng-zorro-antd';
import { RouterModule,Routes } from '@angular/router';
import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

import { ShareModule } from '@share/share.module';

<#if view.hasPSControl('appmenu')>
<#assign appmenu = view.getPSControl('appmenu')>
import { ${srfclassname('${appmenu.name}')}Module } from '@widgets/app/${srffilepath2(appmenu.getCodeName())}-${appmenu.getControlType()?lower_case}/${srffilepath2(appmenu.getCodeName())}-${appmenu.getControlType()?lower_case}.module';
</#if>

import { ${srfclassname('${view.name}')}Page } from './${srffilepath2(view.getCodeName())}.page';

const routes: Routes = [
  {
    path: '',
    redirectTo: '${view.getPSAppModule().codeName?lower_case}_${view.codeName?lower_case}',
    pathMatch: 'full'
  },
  {
    path: '${view.getPSAppModule().codeName?lower_case}_${view.codeName?lower_case}',
    component: ${srfclassname('${view.name}')}Page,
    children: [
      <#if view.getAllRelatedPSAppViewsEx?? && view.getAllRelatedPSAppViewsEx()??>
      <#list view.getAllRelatedPSAppViewsEx() as funcview>
      <#if !funcview.isPickupView()>
      {
        path: '${funcview.getPSAppModule().getCodeName()?lower_case}_${funcview.getCodeName()?lower_case}',
        loadChildren: '@pages/${funcview.getPSAppModule().codeName?lower_case}/${srffilepath2('${funcview.codeName}')}/${srffilepath2('${funcview.codeName}')}.module#${srfclassname('${funcview.codeName}')}Module'
      },
      </#if>
      </#list>
      </#if>
    ]
  }
];

@NgModule({
  imports: [
    RouterModule.forChild(routes)
  ],
  exports: [
    RouterModule
  ]
})
export class ${srfclassname('${view.name}')}RouteModule {}

@NgModule({
  imports: [
    NgZorroAntdModule,
    CommonModule,
    FormsModule,
    ShareModule,
    ${srfclassname('${view.name}')}RouteModule,
    <#if view.hasPSControl('appmenu')>${srfclassname('${appmenu.name}')}Module,</#if>
  ],
  declarations: [ ${srfclassname('${view.name}')}Page]
})
export class ${srfclassname('${view.name}')}Module {}
