# iBiz Mybatis-Plus模板

（技术引用链接）

`Mybatis-Plus`[:arrow_upper_right:](https://mp.baomidou.com/)

（iBiz模型API链接）

`IPSDataEntity`


（以下说明都不是以技术为主，而是以模型为主进行说明，即在模型的特性下如何使用技术进行展现，兼顾iBizSys6平台的一定内容的使用说明）

## 介绍说明

（介绍使用平台xx模型消费了Mybatis-Plus）

iBiz的实体模型简要说明，然后Mybatis-Plus的特性（功能）简要说明，2者正好契合（相结合），然后这套模板应运而生



## 快速开始

## MyBatis-Plus实现CURD  

我们将通过搭建 [MyBatis-Plus官方快速入门示例](https://mp.baomidou.com/guide/quick-start.html) 来阐述 iBizSys 整合 mybatis-plus 的过程，在此之前，我们假设您已经：

- **熟悉iBizSys实体建立**

- **熟悉MyBatis-Plus**

- **熟悉FreeMaker**
	

## 建立实体

建立实体的过程其实就是对应[MyBatis-Plus官方快速入门示例](https://mp.baomidou.com/guide/quick-start.html) 创建数据表的过程，iBizSys将通过管理数据模型的方式来实现对业务表的管理。

![produce](img/createEntity0.png)
![produce](img/createEntity2.png)

## 建立模板

由于MyBatis-Plus 示例中使用Spring Boot作为工程项目，所以本示例中也将使用Spring Boot作为工程项目。

## 依赖模板：

创建一个pom.xml的模板文件【pom.xml.ftl】

![produce](img/pom_ftl.png)

## 配置模板：

创建一个SpringBoot yml配置文件的模板文件【application.yml.ftl】,并在配置文件中添加 H2 数据库的相关配置

![produce](img/yml.png)

## 启动类模板：

创建一个SpringBoot启动类的模板文件【%PUBPRJ%Main.java.ftl】, 文件名参数%PUBPRJ% 为动态参数，代表的是系统名称

![produce](img/AppMain_ftl.png)

## 实体类模板：

创建一个实体类模板文件【%DE%.java.ftl】 , 文件名参数 %DE% 为动态参数，代表的是实体代码名称。iBizSys发布器在发布成果物时，将为系统内的实体模型生成其对应的实体类，以实体的代码名称作为类名

![produce](img/de_ftl.png)

## Mapper类模板：

创建一个Mapper类的模板文件【%DE%Mapper.java.ftl】 , 文件名参数 %DE% 为动态参数，代表的是实体代码名称。

![produce](img/mapper_ftl.png)

## 测试类模板：

创建一个测试类的模板文件【QuickStartTest.java.ftl】

![produce](img/testMain.png)


## 发布模板

您在iBizSys模板工具编写模板后，模板处于暂存状态，若您需要在项目中应用该模板，需要发布该模板。

![produce](img/publishFtl.png)

## 发布模型

发布模型的过程即为从模板仓库中获取最新模板合成模型，生产代码的过程。

![produce](img/publishSystem.png)

## 查看成果物


## 依赖

![produce](img/result_pom.png)

## 配置

![produce](img/result_yml.png)

## 启动类

![produce](img/result_main.png)

## 实体类

![produce](img/result_de.png)

## Mapper类

![produce](img/result_mapper.png)


## 开始使用

运行测试类，进行功能测试：

![produce](img/result_testMain.png)

控制台输出：

![produce](img/console.png)

## 小结

通过以上几个简单的步骤，您已经成功搭建一个（SpringBoot+MyBatis-Plus）的项目，实现了对数据表的CURD功能。并且您也成功了搭建了一套属于您个人的技术模板，您可以在以后的任何项目当中，使用您搭建的这套技术模板。

iBizSys可以帮助您快速搭建并使用您所搭建的技术模板来生产您的项目，想要了解更多iBizSys模板生产体系？那就继续往下看吧！

## MyBatis-Plus实现关系映射

通过第一章的学习，您已经成功搭建了一个基于（SpringBoot+MyBatis-Plus）的项目，实现了对数据表的CURD功能。但我们日常项目经常使用到关系型数据库，经常会遇到（1:N、N:N）关系场景，本章就向大家介绍iBizSys实体关系。

## 建立实体1:N关系

建立两个实体，分别为出版社【PUBLISHER】、书籍【BOOK】，实体关系为： 出版社 1：N  书籍

![produce](img/relations/create_relation.png)

![produce](img/relations/create_relation2.png)

## 模板支持1:N关系

增加Mapper.xml.ftl，用于映射Mybatis的查询结果集【resultMap】

![produce](img/relations/result_map.png)

实体类关联【resultMap】及发布1：N关联属性

![produce](img/relations/de_resultmap.png)


## 开始使用

添加 T_PUBLISHER 表及 T_BOOK 表建表schema脚本

![produce](img/relations/update_schema.png)

添加为 T_PUBLISHER 表及 T_BOOK 表插入测试数据的schema脚本

![produce](img/relations/update_data.png)

运行测试类，从测试结果可以看出，在查询主数据【出版社】时，可以获取到子数据【书籍】对象，从而实现关联查询。

![produce](img/relations/testMain_result.png)

## MyBatis-Plus实现动态查询

通过前两章节的学习，相信你已经初步了解iBizSys的模型发布体系，在第三章，将会向大家介绍iBizSys如何通过MyBatis-Plus实现动态查询。

在项目里可能会经常遇到查询同一个数据表，在不同的地方，需要根据不同的条件进行过滤。此时，查询条件是不固定的，需要动态拼接查询条件进行查询。

技术实现：

可以使用iBizSys为每个实体模型建立搜索项

可以使用MyBatis-Plus提供[条件构造器](https://mp.baomidou.com/guide/wrapper.html)，根据实体搜索项生成条件构造器，在查询时使用条件构造器，MyBatis-Plus将会解析构造器中的条件来动态拼接where条件，从而实现动态查询。

## 配置实体搜索项

建立实体搜索项，支持通过SEX作为条件进行查询。

![produce](img/dycond/cond1.png)

![produce](img/dycond/cond2.png)

## 模板拼接动态条件

为每个实体发布搜索项【searchfilter】

![produce](img/dycond/searchfilter.png)

发布实体服务对象

![produce](img/dycond/IService.png)

发布实体服务对象实现类，用于构造【searchfilter】，并调用mapper进行数据查询

![produce](img/dycond/serviceImpl.png)

提供接口供service调用

![produce](img/dycond/mapper.png)

解析searfilter中的wrapper，动态拼接查询条件

![produce](img/dycond/mapper_xml.png)

## 开始使用

创建【ACTOR】数据表

![produce](img/dycond/test_schema.png)

在【ACTOR】表中插入测试数据

![produce](img/dycond/test_data.png)

运行测试类，控制台输出，已经能够根据实体搜索项【searchfilter】中设定的条件,过滤出SEX=“男”的数据
![produce](img/dycond/console.png)