import FormDetailModel from './form-detail.js';

/**
 * 表单项模型
 * @param {*} opts 
 */
export default class FormItemModel extends FormDetailModel {

    constructor(opts) {
        super(opts);
        /**
         * 错误信息
         */
        this.error = opts.error;
        /**
         * 是否禁用
         */
        this.disabled = opts.disabled ? true : false;
        /**
         * 是否必填
         */
        this.required = opts.required ? true : false;
        /**
         * 是否启用
         */
        this.enableCond = opts.enableCond ? opts.enableCond : 3;

        /**
         * 校验状态
         */
        this.validateStatus = this.validateStatus ? this.validateStatus : "";
    }

        /**
     * 设置是否启用
     *
     * @param {boolean} state
     * @memberof FormItemModel
     */
    setDisabled(state) {
        this.disabled = state;
    }

    /**
     * 设置信息内容
     *
     * @param {string} error
     * @memberof FormItemModel
     */
    setError(error) {
        this.error = error;
        if (!Object.is(error, "")) {
            this.validateStatus = "error";
        } else {
            this.validateStatus = "";
        }
    }

    /**
     * 设置是否启用
     *
     * @param {string} srfuf
     * @memberof FormItemModel
     */
    setEnableCond(srfuf) {
        // 是否有权限
        const isReadOk = true;
        const _srfuf = parseInt(srfuf, 10);
        let state = true;

        if (isReadOk) {
            if (_srfuf === 1) {
                if ((this.enableCond & 2) === 2) {
                    state = false;
                }
            } else {
                if ((this.enableCond & 1) === 1) {
                    state = false;
                }
            }
        }
        this.setDisabled(state);
    }
}
