import FormDetailModel from './form-detail.js';

/**
 * 分页面板模型
 * @param {*} opts 
 */
export default class FormTabPageModel extends FormDetailModel {

    constructor(opts) {
        super(opts);
    }


    /**
     * 设置分页是否启用
     *
     * @param {boolean} state
     * @memberof FormTabPageModel
     */
    setVisible(state) {
        this.visible = state;
        const tabPanel = this.getTabPanelModel();
        if (tabPanel) {
            tabPanel.setActiviePage();
        }
    }

    /**
     * 获取分页面板
     *
     * @returns {(FormTabPanelModel | null)}
     * @memberof FormTabPageModel
     */
    getTabPanelModel() {
        if (!this.form) {
            return null;
        }
        const tabPanels = Object.values(this.form.detailsModel).filter((model) => Object.is(model.detailType, 'TABPANEL'));
        let index = tabPanels.findIndex((tabPanel) => {
            return tabPanel.tabPages.some((tabPag) => Object.is(tabPag.name, this.name));
        });
        if (index === -1) {
            return null;
        }
        const tabPanel = tabPanels[index];
        return tabPanel;
    }

}