# iBiz表单Vue版

## 简介

iBiz表单Vue版是基于vue.js和消费iBiz模型构建而成的表单Demo（下面简称表单），目前，该表单书写了我们表单常用的功能，如表单的栅格布局，flex布局，表单项动态显示，动态启用，动态空输入，表单值规则，表单的数据绑定，表单项的错误提示等功能。如果你的项目使用的前端框架是vue.js,我们可以通过iBiz设计工具来设计我们的表单，然后把iBiz工具产生的成果物集成到我们的项目中，这样可以大大的减轻我们自己的工作压力。当然，由于业务场景的限制，如果有场景不满足，欢迎pr。

## 技术栈

**vue  +   css  +  ant-design-vue   +   tinymce   +   axios    +   moment    +   rxjs    +   vue-i18n**

## 项目运行

git clone  XXXX

cd XXXX

yarn  install

yarn  serve

## 项目结构

把该iBiz表单集成到我们的项目中，也是非常方便的。了解项目集成之前，我们首先来看一下我们的表单目录结构，如下图1：

<div align = center>![1569221899724](superform.assets/1570760897830.png)</div>
<div align = center>图1</div>

```
├── node_modules                      项目的依赖文件
├── public                      
│   ├── assets                        项目的静态资源，包括项目中的图片，其他静态资源
│   ├── favicon.ico
│   ├── index.html                  
├── src  
│   ├──common  
│   │   ├──models                     表单的模型类
│   │   ├──service                    项目的全局服务类
│   │   ├──utils                      项目的工具类
│   ├──components                     项目的基础组件，主要包含所有的编辑器，统一注册到了app-register.js
│   ├──forms                          表单存放的地址
│   ├──pages                          所有视图存放的地址               
│   ├──App.vue                        根组件文件
│   ├──main.js                        项目的入口文件
├── superform.assets
├── .gitignore
├── babel.config.js
├── package.json                      项目的所有依赖文件
├── README.md
├── vue.config.js                     项目的基础配置文件
├── yarn.lock
```

## 项目集成

表单的项目集成该表单也是非常方便，通过以下几个步骤来完成表单的项目集成；

1.在package.json文件中添加依赖，修改vue.config.js文件的基础配置；

<div align = center>![1569223859471](superform.assets/1569467922069.png)</div>
<div align = center>图2</div>

<div align = center>![1569223902448](superform.assets/1569468046164.png)</div>
<div align = center>图3</div>

如上图2，我们需要添加*ant-design-vue*，*moment*，*tinymce*，*rxjs*等组件，如果我们项目之前有引入的话，就不需要引入了，只需要引入我们之前没引入的；如上图3，我们需要设置引用路径的别名。

2.复制静态资源，工具类，基础组件，设置入口文件；

<div align = center>![1569224272508](superform.assets/1570760987595.png)</div>
<div align = center>图4</div>

如上图4，我们需要把public里面的assets文件夹，src下的common文件夹和components文件夹直接copy到我们项目中，这儿需要注意的是路径必须一致，原因是我们之前在vue.config.js文件中设置了项目路径简写。

<div align = center>![1569224554351](superform.assets/1570760092049.png)</div>
<div align = center>图5</div>

如上图5，因为我们使用的组件包是ant-design-vue，基础组件的导出是app-register.js文件，其工具类ComUtil是我们的工具类，所以我们需要在我们的项目中加入上图的代码。

3.完成集成，将iBiz平台的成果物copy到项目中，开始你的表演吧！

## 效果展示

<div align = center>![1569225840767](superform.assets/1569236827973.png)</div>

<div align = center>图7</div>

<div align = center>![1569225768673](superform.assets/1569236902493.png)</div>

<div align = center>图8</div>

<div align = center>![1569225885690](superform.assets/1569236991823.png)</div>

<div align = center>图9</div>

<div align = center>![1569225969577](superform.assets/1569237037706.png)</div>

<div align = center>图10</div>

<div align = center>![1569226015552](superform.assets/1569237065115.png)</div>

<div align = center>图11</div>

## 常见问题

Q1:其中文件上传和图片上传组件由于场景参数不足，上传路径，上传参数，导出参数及自定义参数都需要开发者重新定义。另外，文件上传和图片上传的数据存储格式未知，目前，返回的数据格式与蚂蚁金服提供的一致，若数据存储格式确定但不满足需求，需要开发者在数据输入（handleInputData）和数据抛出（handleOutData）的时候进行数据处理。

## 暂未支持

1.值规则------自定义值规则和脚本

