<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
import {Subject} from 'rxjs';

export default class AppService {

    static appService = new AppService();

    constructor( LanguageList = ["zh", "en"]) {
        this.subject = new Subject();
        this.LanguageList = LanguageList;
        if (!window.localStorage.getItem('curLang')) {
            window.localStorage.setItem('curLang', "zh");
            this.curLanguage = "zh";
        }else{
            this.curLanguage = window.localStorage.getItem('curLang');
        }
    }

    changeLanguage(value) {
        this.curLanguage = value;
        window.localStorage.setItem('curLang', value);
        this.subject.next(value);
    }

    static getInstance() {
        if (!AppService.appService) {
            AppService.appService = new AppService();
        }
        return AppService.appService;
    }

}