<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
const path = require('path');
const os = require('os');

function resolve(dir) {
    return path.join(__dirname, dir)
}

module.exports = {
    publicPath: './',
    // 输出文件目录
    outputDir: 'dist',
    // 去除 map 文件
    productionSourceMap: false,
    devServer: {
        host: '0.0.0.0',
        port: 8111,
        compress: true,
        disableHostCheck: true,
    },
    pages: {
        index: {
            // page 的入口
            entry: 'src/main.js',
            // 模板来源
            template: 'public/index.html',
            // 在 dist/index.html 的输出
            filename: 'index.html',
            // 当使用 title 选项时，
            // template 中的 title 标签需要是 <title><%= htmlWebpackPlugin.options.title %></title>
            title: '超级表单首页',
        }
    },
    chainWebpack: (config) => {
        const pages = ['index'];
        pages.forEach((str) => {
            // 删除自动计算预加载资源
            config.plugins.delete('preload-' + str);
            // 删除预加载资源
            config.plugins.delete('prefetch-' + str);
        });
        config.resolve.alias
            .set('@components', resolve('src/components'))
            .set('@utils', resolve('src/common/utils'))
            .set('@pages', resolve('src/pages'))
            .set('@forms', resolve('src/forms'))
            .set('@models',resolve('src/common/models'))
            .set('@service',resolve('src/common/service'))
    }
}