<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<template>
  <a-locale-provider :locale="locale">
    <div id="app">
      <a-layout id="components-layout-demo-custom-trigger">
        <a-layout-sider :trigger="null" collapsible>
          <div class="logo"><img src="assets/images/logo.png"/></div>
          <a-menu theme="dark" mode="inline" :defaultSelectedKeys="['0']"  @click="handleClick">
          <#if app.getAllPSAppViews()??>
          <#list app.getAllPSAppViews() as singleView>
             <a-menu-item key="${singleView_index}">
              <#if singleView_index % 3 == 0>
              <a-icon type="user" />
              <#elseif singleView_index % 3 == 1>
              <a-icon type="video-camera" />
              <#else>
              <a-icon type="upload" />
              </#if>
              <span>${singleView.getTitle()}</span>
            </a-menu-item>
          </#list>
          </#if>
          </a-menu>
        </a-layout-sider>
        <a-layout>
          <a-layout-content :style="{ margin: '24px 16px', padding: '24px', background: '#fff', minHeight: '280px' }">
          <#if app.getAllPSAppViews()??>
          <#list app.getAllPSAppViews() as singleView>
              <${srfclassname('${singleView.name}')} v-show="curSelected == '${singleView_index}'"/>
          </#list>
          </#if>
          </a-layout-content>
        </a-layout>
      </a-layout>
    </div>
  </a-locale-provider>
</template>

<script>
import zhCN from "ant-design-vue/lib/locale-provider/zh_CN";
<#if app.getAllPSAppViews()??>
<#list app.getAllPSAppViews() as refview>
import ${srfclassname('${refview.name}')} from '@pages/${refview.getPSAppModule().getCodeName()?lower_case}/${srffilepath2('${refview.getCodeName()}')}/${srffilepath2('${refview.getCodeName()}')}.vue';
</#list>
</#if>

export default {
  name: "app",
  components: {
<#if app.getAllPSAppViews()??>
<#list app.getAllPSAppViews() as singleView>
    ${srfclassname('${singleView.name}')}<#if singleView_has_next>,</#if>
</#list>
</#if>
  },
  data() {
    return {
      locale: zhCN,
      curSelected:"0"
    };
  },
  methods:{
    handleClick (e) {
      this.curSelected = e.key;
    }
  }
};
</script>

<style>
.ant-layout.ant-layout-has-sider{
  min-height: 100vh;
} 
#components-layout-demo-custom-trigger .trigger {
  font-size: 18px;
  line-height: 64px;
  padding: 0 24px;
  cursor: pointer;
  transition: color 0.3s;
}

#components-layout-demo-custom-trigger .trigger:hover {
  color: #1890ff;
}

#components-layout-demo-custom-trigger .logo {
  height: 32px;
  text-align: center;
  margin: 16px;
}
</style>