<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
import FormDetailModel from './form-detail.js';

/**
 * 分页部件模型
 * @param {*} opts 
 */

export default class FormTabPanelModel extends FormDetailModel {

    constructor(opts) {
        super(opts);
        /**
        * 被激活分页
        */
        this.activiedPage = "";
        /**
         * 选中激活状态
         */
        this.clickActiviePage = "";
        /**
         * 分页子成员
         */
        this.tabPages = [...opts.tabPages];
        if (this.tabPages.length > 0) {
            this.activiedPage = this.tabPages[0].name;
        }
    }

    /**
     * 设置激活分页
     *
     * @memberof FormTabPanelModel
     */
    setActiviePage() {
        if (!this.form) {
            return;
        }
        const detailsModel = this.form.detailsModel;

        const index = this.tabPages.findIndex((tabpage) => Object.is(tabpage.name, this.clickActiviePage) && Object.is(tabpage.name, this.activiedPage) && detailsModel[tabpage.name].visible);
        if (index !== - 1) {
            return;
        }

        this.tabPages.some((tabpage) => {
            if (detailsModel[tabpage.name].visible) {
                this.activiedPage = tabpage.name;
                return true;
            }
            return false;
        });
    }

    /**
     * 选中页面
     *
     * @param {*} $event
     * @returns {void}
     * @memberof FormTabPanelModel
     */
    clickPage($event) {
        if (!$event) {
            return;
        }

        this.clickActiviePage = $event;
        this.activiedPage = $event;
    }

}