<template>
  <div style="width:800px;margin:0 auto;">
    <a-form :form="form" @submit="handleSubmit" :layout="formLayout">
      <a-tabs defaultActiveKey="1" @change="callback">
        <a-tab-pane tab="Tab 1" key="1">
          <a-form-item
            :label="formdata.note.labelName"
            :label-col="formdata.note.labelCol"
            :wrapper-col="formdata.note.wrapperCol"
            :help="'test'"
            :required="formdata.note.required"
            :validate-status="formdata.note.validateStatus"
            :has-feedback="formdata.note.hasFeedback"
          >
            <a-input
              v-decorator="['note',{rules: [{ required: true, message: 'Please input your note!' }]}]"
            />
          </a-form-item>
          <a-form-item label="Gender" :label-col="{ span: 5 }" :wrapper-col="{ span: 12 }">
            <a-select
              v-decorator="['gender',{rules: [{ required: true, message: 'Please select your gender!' }]}]"
              @change="handleSelectChange"
            >
              <a-select-option value="male">male</a-select-option>
              <a-select-option value="female">female</a-select-option>
            </a-select>
          </a-form-item>
          <a-form-item
            :label-col="formItemLayout.labelCol"
            :wrapper-col="formItemLayout.wrapperCol"
            label="Nickname"
          >
            <a-input
              v-decorator="[
          'nickname',
          {rules: [{ required: checkNick, message: 'Please input your nickname' }]}
        ]"
              placeholder="Please input your nickname"
            />
          </a-form-item>
          <a-form-item :label-col="{span:4}" :wrapper-col="{ span: 8, offset: 4 }">
            <a-checkbox :checked="checkNick" @change="handleChange">Nickname is required</a-checkbox>
          </a-form-item>
          <a-form-item :wrapper-col="{ span: 12, offset: 5 }">
            <a-button type="primary" html-type="submit">提交</a-button>
          </a-form-item>
        </a-tab-pane>
        <a-tab-pane tab="Tab 2" key="2" forceRender>Content of Tab Pane 2</a-tab-pane>
      </a-tabs>
    </a-form>
  </div>
</template>

<script>
export default {
  name: "${ctrl.getCodeName()}${ctrl.getName()}",
  data() {
    return {
      formLayout: "Inline",
      form: this.$form.createForm(this),
      formItemLayout: {
        labelCol: { span: 5 },
        wrapperCol: { span: 12 }
      },
      checkNick: false,
      formdata: {
        note: {
          labelName: "Note",
          labelCol: { span: 5 },
          wrapperCol: { span: 12 },
          help: "",
          required: "true",
          validateStatus: "warning",
          hasFeedback: true
        }
      }
    };
  },
  methods: {
    callback(key) {
      console.log(key);
    },
    handleSubmit(e) {
      e.preventDefault();
      this.form.validateFields((err, values) => {
        if (!err) {
          console.log("Received values of form: ", values);
        }
      });
    },
    handleSelectChange(value) {
      console.log(value);
      this.form.setFieldsValue({
      
      });
      console.log(ComUtil.createUUID());
    },
    handleChange(e) {
      this.checkNick = e.target.checked;
      this.$nextTick(() => {
        this.form.validateFields(["nickname"], { force: true });
      });
    }
  }
};
</script>
<style scoped>

</style>
