<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<template>
    <a-select :value="value" v-bind:style="curStyleObj" :placeholder="placeholder" :disabled="disabled" allowClear   @change="onChange">
      <a-select-option v-for="item in curCodelist" v-bind:key="item.id" :value="item.id">{{$t(item.text)}}</a-select-option>
    </a-select>
</template>
<script>
export default {
  name: "AppDropdownList",
  model: {
    prop: "value",
    event: "change"
  },
  props: {
    tag:String,
    value: String,
    disabled: Boolean,
    isauto:Boolean,
    tag:String,
    codelist:Object,
    placeholder:String
  },
  computed:{
      curCodelist:function(){
          return this.codelist[this.tag];
      },
      curStyleObj:function(){
          return {width:this.isauto == true?'100%':'100px'};
      }
  },
  methods: {
    onChange($event) {
      this.$emit("change",$event);
    }
  }
};
</script>
<style>
</style>