<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<template>
  <a-date-picker
    :value="dateValue"
    :disabled="disabled"
    :format="format"
    :showTime="showTime"
    :placeholder="placeholder"
    @change="onChange"
  />
</template>

<script>
const moment = require("moment");
export default {
  name: "AppDatePicker",
  model: {
    prop: "value",
    event: "change"
  },
  props: {
    value: String,
    disabled: Boolean,
    format: String,
    placeholder: String,
    showTime:Boolean
  },
  computed: {
    dateValue: function() {
      return this.value ? moment(this.value) : null;
    }
  },
  methods: {
    onChange(date, dateString) {
      this.$emit("change", dateString);
    }
  }
};
</script>
<style>
</style>
