<template>
${P.getPartCode(item,'FORM').code}
</template>

<script>
import  { FormButtonModel,FormDetailModel,FormItemModel,FormDRUIPartModel,FormGroupPanelModel,FormIFrameModel,FormPageModel,FormPartModel,FormRowItemModel,FormTabPageModel,FormTabPanelModel,FormUserControlModel}  from "@models/index.js";
import ComUtil from '@utils/ComUtil';
import AppService from "@service/AppService";
export default {
  
  name: "${ctrl.getCodeName()}${ctrl.getName()}",

  data() {
    return {

      /**
      * 当前语言
      *
      */
      local:"",
    
      /**
      * 激活分组
      *
      */
      activeGroup:[<#if ctrl.getAllPSDEFormDetails()??><#list ctrl.getAllPSDEFormDetails() as formitem><#if formitem.getDetailType() == "GROUPPANEL">"${formitem.getName()}",</#if></#list></#if>],
      
      /**
      * 激活分组
      *
      */
      data:{
        <#list ctrl.getPSDEFormItems() as item>
        ${item.getName()}: null,
        </#list>
      },

      /**
      * 表单模型
      *
      */
      detailsModel:{
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        ${formdetail.name}: ${P.getPartCode(formdetail, 'DETAIL_MODEL').code}, 
        </#list>
        <#if !ctrl.isNoTabHeader()>
        ${ctrl.name}: new FormTabPanelModel({ caption: '${ctrl.name}', detailType: 'TABPANEL', name: '${ctrl.name}', visible: true, isShowCaption: true, form: this, tabPages: [<#list ctrl.getPSDEFormPages() as formmenber><#if formmenber_index gt 0>, </#if>{ name: '${formmenber.name}', index: ${formmenber_index}, visible: <#if formmenber.getPSDEFDGroupLogic('PANELVISIBLE')??>false<#else>true</#if> }</#list>] }),
        </#if>
      },

      /**
      * 代码表模型
      *
      */      
      codelistModel:{
        <#if view.getAllRelatedPSCodeLists()??>
        <#list view.getAllRelatedPSCodeLists() as codelist>
        <#if codelist.getAllPSCodeItems()??>
        "${codelist.getSystemTag()}_${codelist.codeName}":[
        <#list codelist.getAllPSCodeItems() as codeItem>
        {"id":"${codeItem.getValue()}","text":"${view.name?lower_case}.${codelist.getSystemTag()}_${codelist.codeName}.${codeItem.getValue()}","disabled":${codeItem.isDisableSelect()?c}}<#if codeItem_has_next>,</#if>
        </#list>
        ]<#if codelist_has_next>,</#if>
        </#if>
        </#list>
        </#if>
      },

      /**
      * 值规则
      *
      */
      rules:{
        <#list ctrl.getAllPSDEFormDetails() as formdetail>
        <#if formdetail.getDetailType?? && formdetail.getDetailType() == 'FORMITEM'>
        ${formdetail.getName()}: [
            { required: <#if formdetail.isAllowEmpty()>false<#else>true</#if>, type: '<#assign datatype=srfjavatype(formdetail.getStdDataType())><#if datatype=='BigInteger' || datatype=='Integer' || datatype=='Double'>number<#else>string</#if>', message: '${formdetail.getCaption()}值不能为空'},
        ],
        </#if>
        </#list>
      }
    };
  },

  created(){
        this.initForm();
        this.initlangu();
  },

  methods: {

    /**
     * 初始化表单
     *
     */
    initForm(){
        if(Object.keys(this.data).length >0){
             Object.keys(this.data).forEach((item) =>{
                     this.formItemChange(item,this.data[item],true);
             })   
        }
    },

    /**
     * 初始化语言
     * 
     */
    initlangu(){
        if (Object.is(window.localStorage.getItem("curLang"), "zh")) {
                this.local ="zh_CN";
        } else {
                this.local ="en_GB";
        }
        AppService.getInstance().subject.subscribe(res => {
            if (Object.is(res, "zh")) {
                this.local ="zh_CN";
            } else {
                this.local ="en_GB";
            }
        });
    },

    /**
     * 分页选中
     *
     */
    formPageSelected(key){
      console.log("表单选中了"+key);
    },

    /**
     * 重置校验结果
     *
     */
    resetValidates() {
        Object.values(this.detailsModel).forEach((detail) => {
            if (!Object.is(detail.detailType, 'FORMITEM')) {
                return;
            }
            const formItem = detail;
            formItem.setError('');
        });
    },

    /**
     * 填充校验结果
     *
     */
    fillValidates(fieldErrors){
        fieldErrors.forEach((error) => {
            const formItem = this.detailsModel[error.field];
            if (!formItem) {
                return;
            }
            this.$nextTick(() => {
                formItem.setError(error.message);
            });
        });
    },

    /**
     *  按钮点击事件
     *
     */
    button_click($event,caption){
      this.$message.success("点击了"+caption);
    },

    /**
     * 表单项值变化
     *
     */
    formItemChange(name,value,isFirst){
      this.resetValidates();
      this.formLogic(name,value);
      if(!isFirst){
        this.checkRule(name,value); 
      }
    },

    /**
     * 表单值规则校验
     *
     */    
    checkRule(name,value){
        if(this.rules[name][0].required){
                if(ComUtil.isEmpty(this.data[name])){
                        this.detailsModel[name].validateStatus ="error";
                        this.detailsModel[name].error =this.rules[name][0].message;
                }else{
                        this.detailsModel[name].validateStatus ="";
                        this.detailsModel[name].error ="";
                }
        }
    },

    /**
     * 表单逻辑
     *
     */
    formLogic( name, newVal, oldVal) {
      <#if P.getPartCode(item,'FORM_LOGIC').code?length gt 0>
      ${P.getPartCode(item,'FORM_LOGIC').code}
      </#if>
      <#if ctrl.getPSDEFormItems()??>
      <#list ctrl.getPSDEFormItems() as formitem>
      <#if formitem.getPSDEFormItemUpdate()??>
      if(Object.is(name, '${formitem.name}')){
          this.updateFormItems('${formitem.getPSDEFormItemUpdate().codeName}', this.data,false);
      }
      </#if>
      </#list>
      </#if>
    }
  }
}
</script>
<style scoped>

</style>
