<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<#noparse>
<template>
  <div>
    <textarea :id="id"></textarea>
  </div>
</template>

<script>
import { Subject } from "rxjs";
import axios from "axios";
import tinymce from "tinymce/tinymce";
import "tinymce/themes/modern";
import "tinymce/plugins/link";
import "tinymce/plugins/paste";
import "tinymce/plugins/table";
import "tinymce/plugins/image";
import "tinymce/plugins/imagetools";
import "tinymce/plugins/codesample";
import "tinymce/plugins/code";
import "tinymce/plugins/fullscreen";
import "tinymce/plugins/preview";

import ComUtil from "@utils/ComUtil";

export default {
  name: "AppRichTextEditor",
  model: {
    prop: "value",
    event: "change"
  },
  props: {
    value: String,
    height: Number,
    disabled: Boolean,
    langu: String,
    uploadurl: String,
    downloadurl: String
  },
  data() {
    return {
      editor: null | Object,
      id: ComUtil.createUUID()
    };
  },
  computed: {
    uploadUrl: function() {
      return this.uploadurl ? this.uploadurl : "";
    },
    downloadUrl: function() {
      return this.downloadurl ? this.downloadurl : "";
    }
  },
  watch: {
    langu: {
      handler: "onLanguChanged"
    }
  },
  mounted() {
    this.init("");
  },
  destroyed() {
    tinymce.remove(this.editor);
  },
  methods: {
    init(val) {
      let richtexteditor = this;
      tinymce.init({
        selector: "#" + this.id,
        height: this.height,
        min_height: 400,
        branding: false,
        plugins: [
          "link",
          "paste",
          "table",
          "image",
          "codesample",
          "code",
          "fullscreen",
          "preview"
        ],
        codesample_languages: [
          { text: "HTML/XML", value: "markup" },
          { text: "JavaScript", value: "javascript" },
          { text: "CSS", value: "css" },
          { text: "PHP", value: "php" },
          { text: "Ruby", value: "ruby" },
          { text: "Python", value: "python" },
          { text: "Java", value: "java" },
          { text: "C", value: "c" },
          { text: "C#", value: "csharp" },
          { text: "C++", value: "cpp" }
        ],
        codesample_content_css: "https://cdn.ibizlab.cn/super-form/tinymce/prism.css",
        skin_url: "https://cdn.ibizlab.cn/super-form/tinymce/skins/lightgray",
        language_url:
          "https://cdn.ibizlab.cn/super-form/tinymce/langs/" +
          (this.langu ? this.langu : "zh_CN") +
          ".js",
        setup: editor => {
          this.editor = editor;
          editor.on("blur", () => {
            const content = editor.getContent();
            this.$emit("change", content);
          });
        },
        images_upload_handler: (bolbinfo, success, failure) => {
          const formData = new FormData();
          formData.append("file", bolbinfo.blob(), bolbinfo.filename());
          if (Object.is(richtexteditor.uploadUrl, "")) {
            failure("需要提供上传路径");
          } else {
            const _url = richtexteditor.uploadUrl;
            richtexteditor.uploadFile(_url, formData).subscribe(
              response => {
                if (response.ret === 0 && response.files.length > 0) {
                  if (Object.is(richtexteditor.downloadUrl, "")) {
                    failure("需要提供下载路径");
                  } else {
                    const id = response.files[0].id;
                    const url = `${richtexteditor.downloadUrl}?fileid=${id}`;
                    success(url);
                  }
                }
              },
              error => {
                console.log(error);
              }
            );
          }
        },
        init_instance_callback: editor => {
          this.editor = editor;
          let value = this.value && this.value.length > 0 ? this.value : "";
          if (this.editor) {
            this.editor.setContent(value);
          }
          if (this.disabled) {
            this.editor.setMode("readonly");
          }
        }
      });
    },
    uploadFile(url, formData) {
      let _this = this;
      const subject = new Subject();
      axios({
        method: "post",
        url: url,
        data: formData,
        headers: { "Content-Type": "image/png", Accept: "application/json" }
      })
        .then(response => {
          if (response.status === 200) {
            subject.next(response.data);
          } else {
            subject.error(response);
          }
        })
        .catch(response => {
          subject.error(response);
        });
      return subject;
    },
    onLanguChanged(val, oldVal) {
      if (!Object.is(val, oldVal)) {
        const content = this.editor.getContent();
        tinymce.remove(this.editor);
        this.init(content);
        this.$forceUpdate();
      }
    }
  }
};
</script>
<style>
</style>
</#noparse>
