<template>
<#ibizinclude>
../@MACRO/HTML/LAYOUTPANEL_VIEW.html.ftl
</#ibizinclude>
</template>

<script>
export default {
  name: "Demo",

  data() {
    return {
      formLayout: "Inline",
      form: this.$form.createForm(this),
      formItemLayout: {
        labelCol: { span: 5 },
        wrapperCol: { span: 12 }
      },
      checkNick: false,
      formdata: {
        note: {
          labelName: "Note",
          labelCol: { span: 5 },
          wrapperCol: { span: 12 },
          help: "",
          required: "true",
          validateStatus: "warning",
          hasFeedback: true
        }
      }
    };
  },
  methods: {
    callback(key) {
      console.log(key);
    },
    handleSubmit(e) {
      e.preventDefault();
      this.form.validateFields((err, values) => {
        if (!err) {
          console.log("Received values of form: ", values);
        }
      });
    },
    handleSelectChange(value) {
      console.log(value);
      this.form.setFieldsValue({
        note: `Hi, ${value === "male" ? "man" : "lady"}!`
      });
      console.log(ComUtil.createUUID());
    },
    handleChange(e) {
      this.checkNick = e.target.checked;
      this.$nextTick(() => {
        this.form.validateFields(["nickname"], { force: true });
      });
    }
  }
};
</script>
<style scoped>
<#ibizinclude>
../@MACRO/CSS/LAYOUTPANEL_VIEW.css.ftl
</#ibizinclude>
</style>
