<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<template>
  <a-checkbox-group :value="selectArray" :disabled="disabled" @change="onChange">
    <a-checkbox v-for="item in curCodelist" v-bind:key="item.id" :value="item.id">{{$t(item.text)}}</a-checkbox>
  </a-checkbox-group>
</template>

<script>
export default {
  name: "AppCheckBoxGroup",
  model: {
    prop: "value",
    event: "change"
  },
  props: {
    tag: String,
    value: String | Number,
    disabled: Boolean,
    codelist: Object,
    /**
     * 模式（数字或者字符串）
     *
     */
    mode: String,
    /**
     * 分隔符
     *
     */
    separator: String
  },
  computed: {
    curCodelist: function() {
      return this.codelist[this.tag];
    },

    /**
     * 当前模式
     *
     */
    currentmode: function() {
      if (this.mode) {
        return this.mode;
      } else {
        return "str";
      }
    },

    /**
     * 获取分隔符
     *
     */
    currentseparator: function() {
      if (this.separator) {
        return this.separator;
      } else {
        return ";";
      }
    },
    /**
     * 选中数组
     *
     */
    selectArray: function() {
      if (this.value) {
        if (Object.is(this.currentmode, "num") && this.curCodelist) {
          let selectsArray = [];
          let num = parseInt(this.value, 10);
          this.curCodelist.forEach(item => {
            if ((num & item.id) == item.id) {
              selectsArray.push(item.id);
            }
          });
          return selectsArray;
        } else if (Object.is(this.currentmode, "str")) {
          if (this.value !== "") {
            return this.value.split(this.currentseparator);
          }else{
            return [];
          }
        }
      } else {
        return [];
      }
    }
  },
  methods: {
    onChange(val) {
      let value = null;
      if (Object.is(this.currentmode, "num")) {
        let temp = 0;
        val.forEach(item => {
          temp = temp | parseInt(item, 10);
        });
        value = temp;
      } else if (Object.is(this.currentmode, "str")) {
        let _datas = [];
        this.curCodelist.forEach(item => {
          const index = val.findIndex(_key => Object.is(item.id, _key));
          if (index === -1) {
            return;
          }
          _datas.push(item.id);
        });
        value = _datas.join(this.currentseparator);
      }
      this.$emit("change", value);
    }
  }
};
</script>
<style>
</style>
