<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<template>
  <a-form-item
    v-bind:class="actualClass"
    :validate-status="validateStatus"
  >
    <span
      class="app-form-item-label"
      v-bind:style="{ width: labelwidth,height:'32px'}"
      v-show="isShowCaption"
    >
      <span v-show="this.required" class="isrequired">*</span>
      {{labelName}}
    </span>
    <span class="app-form-item-content" v-bind:style="actualContentStyle">
      <slot></slot>
    </span>
    <template v-slot:help>
      <div v-bind:style="{'padding-left':labelPosition ==='LEFT'?labelwidth:'0px',height:'20px'}">{{helpInfo}}</div>
    </template>
  </a-form-item>
</template>

<script>
export default {
  // v-bind:style="formItemStyle"
  name: "AppFormItem",
  props: {
    helpInfo: String,
    validateStatus: String,
    labelName: String,
    labelwidth: String,
    labelPosition: String,
    isShowCaption: Boolean,
    formItemStyle: Object,
    isEmptyCaption: Boolean,
    formItemContentStyle: Object,
    required: Boolean
  },
  data() {
    return {
      rules: [],
    };
  },
  computed: {
    actualClass: function() {
      if (Object.is(this.labelPosition, "TOP")) {
        return { "app-form-item": true, "app-form-item-top": true };
      } else if (Object.is(this.labelPosition, "BOTTOM")) {
        return { "app-form-item": true, "app-form-item-bottom": true };
      } else if (Object.is(this.labelPosition, "RIGHT")) {
        return { "app-form-item": true, "app-form-item-right": true };
      } else {
        return { "app-form-item": true };
      }
    },
    actualContentStyle: function() {
      if (Object.keys(this.formItemContentStyle).length > 0) {
        return Object.assign(
          { width: "calc(100% - " + this.labelwidth + ")" },
          this.formItemContentStyle
        );
      } else {
        return { width: "calc(100% - " + this.labelwidth + ")" };
      }
    }
  }
};
</script>
<style>
.app-form-item-top .app-form-item-label {
  display: block;
}
.app-form-item-top .app-form-item-content {
  display: block !important;
}

.app-form-item-right .app-form-item-label {
  float: right;
}
.app-form-item-right .app-form-item-content {
  float: left;
}
.app-form-item-bottom .ant-form-item-children {
  display: flex !important;
  flex-direction: column-reverse !important;
}
.app-form-item .app-form-item-label {
  display: inline-block;
  padding-right: 16px;
  text-align: right;
  vertical-align: top;
}
.app-form-item .app-form-item-content {
  display: inline-block;
  text-align: left;
}
.app-form-item-label .isrequired {
  display: inline-block;
  margin-right: 4px;
  font-family: SimSun;
  line-height: 1;
  font-size: 14px;
  color: #f5222d;
}
</style>
