<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<template>
  <a-time-picker
    :value="dateValue"
    :disabled="disabled"
    :format="format"
    :placeholder="placeholder"
    @change="onChange"
    allowEmpty
  />
</template>

<script>
const moment = require("moment");
export default {
  name: "AppTimePicker",
  model: {
    prop: "value",
    event: "change"
  },
  props: {
    id: String,
    value: String,
    disabled: Boolean,
    format: String,
    placeholder: String
  },
  computed: {
    dateValue: function() {
      return this.value ? moment(this.value, this.format) : null;
    }
  },
  methods: {
    onChange(date, dateString) {
      this.$emit("change", dateString);
    }
  }
};
</script>
<style>
</style>
