<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
/**
 * 表单成员模型
 *
 */
export default class FormDetailModel {

    constructor(opts) {
        /**
         *  成员标题
         */
        this.caption = !Object.is(opts.caption, '') ? opts.caption : '';
        /**
         * 成员类型
         */
        this.detailType = !Object.is(opts.detailType, '') ? opts.detailType : '';
        /**
         * 表单对象
         */
        this.form = opts.form ? opts.form : {};
        /**
         * 成员名称
         */
        this.name = !Object.is(opts.name, '') ? opts.name : '';
        /**
         * 成员是否显示
         */
        this.visible = opts.visible ? true : false;
        /**
         * 成员是否显示标题
         */
        this.isShowCaption = opts.isShowCaption ? true : false;
    }


    /**
     * 设置显示与隐藏
     *
     * @param {boolean} state
     * @memberof FormDetailModel
     */
    setVisible(state) {
        this.visible = state;
    }
    
    /**
    * 设置显示标题栏
    *
    * @param {boolean} state
    * @memberof FormDetailModel
    */
    setShowCaption(state) {
        this.isShowCaption = state;
    }
}
