<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<template>
  <div class="clearfix">
    <a-upload
      :action="uploadurl"
      accept="image/*"
      :multiple="multiple"
      listType="picture-card"
      :fileList="fileList"
      :disabled="disabled"
      @preview="handlePreview"
      @change="handleChange"
    >
      <div v-if="fileList.length < maxlength">
        <a-icon type="plus" />
        <div class="ant-upload-text">{{$t('upload')}}</div>
      </div>
    </a-upload>
    <a-modal :visible="previewVisible" :footer="null" @cancel="handleCancel">
      <img alt="example" style="width: 100%" :src="previewImage" />
    </a-modal>
  </div>
</template>
<script>
export default {
  name: "AppImageUpload",
  model: {
    prop: "value",
    event: "change"
  },
  props: {
    value: Array,
    disabled: Boolean,
    multiple: Boolean,
    uploadparams: String,
    exportparams: String,
    customparams: Object
  },
  computed: {
    fileList: {
      get: function() {
        return this.value ? this.handleInputData(this.value) : [];
      },
      set: function(val) {
        this.$emit("change", this.handleOutData(val));
      }
    },
    maxlength: function() {
      return this.multiple ? 3 : 1;
    }
  },
  data() {
    return {
      uploadurl: "https://www.mocky.io/v2/5cc8019d300000980a055e76",
      previewVisible: false,
      previewImage: ""
    };
  },
  methods: {
    handleCancel() {
      this.previewVisible = false;
    },
    handlePreview(file) {
      this.previewImage = file.url || file.thumbUrl;
      this.previewVisible = true;
    },
    handleChange({ file, fileList, event }) {
      this.fileList = fileList;
    },
    handleOutData(value) {
      //todo  输出之前处理数据格式
      return value;
    },
    handleInputData(value) {
      //todo  输入之前处理数据格式
      return value;
    }
  }
};
</script>
<style>
.ant-upload-select-picture-card i {
  font-size: 32px;
  color: #999;
}

.ant-upload-select-picture-card .ant-upload-text {
  margin-top: 8px;
  color: #666;
}
</style>