<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<#noparse>
<template>
  <a-upload
    name="file"
    :multiple="true"
    :defaultFileList="fileList"
    :disabled="disabled"
    :action="uploadurl"
    :headers="headers"
    @change="handleChange"
  >
    <a-button>
      <a-icon type="upload" />{{$t('upload')}}
    </a-button>
  </a-upload>
</template>
<script>
export default {
  name: "AppFileUpload",
  model: {
    prop: "value",
    event: "change"
  },
  props: {
    value: Array,
    disabled: Boolean,
    uploadparams: String,
    exportparams: String,
    customparams: Object
  },
  computed: {
    fileList: {
      get: function() {
        return this.value ? this.handleInputData(this.value) : [];
      },
      set: function(val) {
        this.$emit("change", this.handleOutData(val));
      }
    }
  },
  data() {
    return {
      uploadurl: "https://www.mocky.io/v2/5cc8019d300000980a055e76",
      headers: {
        authorization: "authorization-text"
      }
    };
  },
  methods: {
    handleChange(info) {
      if (info.file.status === "done") {
        this.fileList = info.fileList;
        this.$message.success(`${info.file.name} 上传成功`);
      } else if (info.file.status === "error") {
        this.$message.error(`${info.file.name} 上传失败`);
      }
    },
    handleOutData(value) {
      //todo  输出之前处理数据格式
      return value;
    },
    handleInputData(value) {
      //todo  输入之前处理数据格式
      return value;
    }
  }
};
</script>
<style>
</style>
</#noparse>