<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<template>
  <a-radio-group :name="tag" :value="value" :disabled="disabled" @change="onChange">
    <a-radio v-for="item in curCodelist" v-bind:key="item.id" :value="item.id">{{$t(item.text)}}</a-radio>
  </a-radio-group>
</template>
<script>
export default {
  name: "AppRadioGroup",
  model: {
    prop: "value",
    event: "change"
  },
  props: {
    tag: String,
    value: String,
    disabled: Boolean,
    codelist: Object
  },
  computed: {
    curCodelist: function() {
      return this.codelist[this.tag];
    }
  },
  methods: {
    onChange($event) {
      this.$emit("change", $event.target.value);
    }
  }
};
</script>
<style>
</style>